/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.client.WorldTierSelectScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class WorldTierTutorialScreen
extends Screen {
    private final WorldTierSelectScreen parent;
    private TutorialStage stage = TutorialStage.INTRODUCTION;
    private SimpleTexButton skipButton;
    private SimpleTexButton prevButton;
    private SimpleTexButton nextButton;

    public WorldTierTutorialScreen(WorldTierSelectScreen parent, Component title) {
        super(title);
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int imgLeft = (this.width - 498) / 2;
        int imgTop = (this.height - 286) / 2;
        this.skipButton = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)SimpleTexButton.builder().size(80, 20).pos(imgLeft + 15, imgTop + 250).texture(SimpleTexButton.APOTH_SPRITES).action(btn -> this.closeTutorial()).buttonText((Component)Apotheosis.lang("button", "skip_tutorial", new Object[0])).build());
        this.prevButton = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)SimpleTexButton.builder().size(60, 20).pos(imgLeft + 340, imgTop + 250).texture(SimpleTexButton.APOTH_SPRITES).action(btn -> {
            this.stage = this.stage.prev();
            this.updateButtons();
        }).buttonText((Component)Apotheosis.lang("button", "prev_tutorial", new Object[0])).build());
        this.nextButton = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)SimpleTexButton.builder().size(60, 20).pos(imgLeft + 420, imgTop + 250).texture(SimpleTexButton.APOTH_SPRITES).action(btn -> {
            this.stage = this.stage.next();
            this.updateButtons();
            if (this.stage == null) {
                this.closeTutorial();
            }
        }).buttonText((Component)Apotheosis.lang("button", "next_tutorial", new Object[0])).build());
        this.updateButtons();
    }

    public void renderBackground(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        int imgLeft = (this.width - 498) / 2;
        int imgTop = (this.height - 286) / 2;
        RenderSystem.enableBlend();
        gfx.blit(this.stage.overlay, imgLeft, imgTop, 0.0f, 0.0f, 498, 286, 498, 286);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.render(gfx, mouseX, mouseY, partialTick);
        int imgLeft = (this.width - 498) / 2;
        int imgTop = (this.height - 286) / 2;
        PoseStack pose = gfx.pose();
        float scale = 2.0f;
        pose.pushPose();
        pose.scale(scale, scale, 1.0f);
        Component title = this.stage.title;
        gfx.drawString(this.font, title.getVisualOrderText(), ((float)(imgLeft + 380) - (float)this.font.width((FormattedText)title) * scale / 2.0f) / scale, (float)(imgTop + 107) / scale, 0xFFFFFF, true);
        pose.popPose();
        List split = this.font.split((FormattedText)this.stage.description, 200);
        for (int i = 0; i < split.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)split.get(i);
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, line, imgLeft + 280, imgTop + 100 + 9 * 3 + (2 + 9) * i, 0xFFFFFF, true);
        }
        if (this.stage == TutorialStage.WORLD_TIERS) {
            for (SimpleTexButton btn : this.parent.tierButtons.values()) {
                btn.render(gfx, mouseX, mouseY, partialTick);
            }
        } else if (this.stage == TutorialStage.DETAILED_INFO) {
            this.parent.detailButton.render(gfx, mouseX, mouseY, partialTick);
        } else if (this.stage == TutorialStage.ACTIVATE) {
            this.parent.activateButton.render(gfx, mouseX, mouseY, partialTick);
        }
    }

    private void updateButtons() {
        this.skipButton.active = true;
        boolean bl = this.prevButton.active = this.stage != TutorialStage.INTRODUCTION;
        if (this.stage == TutorialStage.ACTIVATE) {
            this.nextButton.setButtonText((Component)Apotheosis.lang("button", "done", new Object[0]));
        } else {
            this.nextButton.setButtonText((Component)Apotheosis.lang("button", "next_tutorial", new Object[0]));
        }
    }

    private void closeTutorial() {
        this.minecraft.popGuiLayer();
        this.parent.closeTutorial();
    }

    private static enum TutorialStage {
        INTRODUCTION("introduction"),
        WORLD_TIERS("world_tiers"),
        TIER_NAME("tier_name"),
        TIER_DIFFICULTY("tier_difficulty"),
        DETAILED_INFO("detailed_info"),
        ACTIVATE("activate");

        private ResourceLocation overlay;
        private Component title;
        private Component description;

        private TutorialStage(String name) {
            this.overlay = Apotheosis.loc("textures/gui/tutorial/" + name + ".png");
            this.title = Apotheosis.lang("tutorial", "world_tier." + name + ".title", new Object[0]);
            this.description = Apotheosis.lang("tutorial", "world_tier." + name + ".desc", new Object[0]);
        }

        @Nullable
        public TutorialStage next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> WORLD_TIERS;
                case 1 -> TIER_NAME;
                case 2 -> TIER_DIFFICULTY;
                case 3 -> DETAILED_INFO;
                case 4 -> ACTIVATE;
                case 5 -> null;
            };
        }

        @Nullable
        public TutorialStage prev() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> null;
                case 1 -> INTRODUCTION;
                case 2 -> WORLD_TIERS;
                case 3 -> TIER_NAME;
                case 4 -> TIER_DIFFICULTY;
                case 5 -> DETAILED_INFO;
            };
        }
    }
}

