/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.client.WorldTierDetailScreen;
import dev.shadowsoffire.apotheosis.client.WorldTierTutorialScreen;
import dev.shadowsoffire.apotheosis.net.WorldTierPayload;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class WorldTierSelectScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Apotheosis.loc("textures/gui/mountain.png");
    public static final ResourceLocation SEPARATOR_LINE = Apotheosis.loc("textures/gui/separator_line.png");
    public static final ResourceLocation SWORD_EMPTY = Apotheosis.loc("textures/gui/sword_empty.png");
    public static final ResourceLocation SWORD_FULL = Apotheosis.loc("textures/gui/sword_full.png");
    public static final AnimationData HAVEN_ANIMATION = new AnimationData(138, 156, 21, 320, 10, Apotheosis.loc("textures/gui/animations/haven.png"));
    public static final AnimationData FRONTIER_ANIMATION = new AnimationData(210, 236, 45, 588, 21, Apotheosis.loc("textures/gui/animations/frontier.png"));
    public static final AnimationData ASCENT_ANIMATION = new AnimationData(251, 106, 42, 1380, 30, Apotheosis.loc("textures/gui/animations/ascent.png"));
    public static final AnimationData SUMMIT_ANIMATION = new AnimationData(349, 41, 5, 640, 20, Apotheosis.loc("textures/gui/animations/summit.png"));
    public static final AnimationData PINNACLE_ANIMATION = new AnimationData(356, -2, 47, 960, 12, Apotheosis.loc("textures/gui/animations/pinnacle.png"));
    public static final int GUI_WIDTH = 480;
    public static final int GUI_HEIGHT = 270;
    public static final int IMAGE_WIDTH = 498;
    public static final int IMAGE_HEIGHT = 286;
    protected SimpleTexButton activateButton;
    protected SimpleTexButton detailButton;
    protected SimpleTexButton tutorialButton;
    protected WorldTier displayedTier;
    protected int leftPos;
    protected int topPos;
    protected Map<WorldTier, SimpleTexButton> tierButtons;
    protected int animTicks;

    public WorldTierSelectScreen() {
        super((Component)Apotheosis.lang("title", "select_world_tier", new Object[0]));
        this.displayedTier = WorldTier.getTier((Player)Minecraft.getInstance().player);
        this.tierButtons = new EnumMap<WorldTier, SimpleTexButton>(WorldTier.class);
        this.animTicks = 0;
    }

    protected void init() {
        this.leftPos = Math.max(0, (this.width - 480) / 2);
        this.topPos = Math.max(0, (this.height - 270) / 2);
        this.addTierButton(WorldTier.HAVEN, b -> b.pos(this.leftPos + 100, this.topPos + 215));
        this.addTierButton(WorldTier.FRONTIER, b -> b.pos(this.leftPos + 210, this.topPos + 205));
        this.addTierButton(WorldTier.ASCENT, b -> b.pos(this.leftPos + 230, this.topPos + 115));
        this.addTierButton(WorldTier.SUMMIT, b -> b.pos(this.leftPos + 315, this.topPos + 60));
        this.addTierButton(WorldTier.PINNACLE, b -> b.pos(this.leftPos + 395, this.topPos));
        this.activateButton = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)SimpleTexButton.builder().size(60, 24).pos(this.leftPos + 198, this.topPos + 15).texture(SimpleTexButton.APOTH_SPRITES).action(this.activateSelectedTier()).buttonText((Component)Apotheosis.lang("button", "activate_tier", new Object[0])).build());
        this.detailButton = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)SimpleTexButton.builder().size(80, 20).pos(this.leftPos + 178, this.topPos + 75).texture(SimpleTexButton.APOTH_SPRITES).action(this.openDetailedInfoScreen()).buttonText((Component)Apotheosis.lang("button", "show_detailed_info", new Object[0])).message((Component)Apotheosis.lang("button", "show_detailed_info.desc", new Object[0])).build());
        this.tutorialButton = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)SimpleTexButton.builder().size(12, 15).pos(this.leftPos + 480 - 14, this.topPos + 270 - 17).texture(SimpleTexButton.APOTH_SPRITES).action(btn -> this.minecraft.pushGuiLayer((Screen)new WorldTierTutorialScreen(this, (Component)Apotheosis.lang("title", "world_tier_tutorial", new Object[0])))).buttonText((Component)Component.literal((String)"?")).message((Component)Apotheosis.lang("button", "open_world_tier_tutorial", new Object[0])).build());
        this.updateButtonStatus();
        if (this.minecraft.screen == this && WorldTier.isTutorialActive((Player)this.minecraft.player) && WorldTier.isUnlocked((Player)this.minecraft.player, WorldTier.HAVEN)) {
            this.minecraft.pushGuiLayer((Screen)new WorldTierTutorialScreen(this, (Component)Apotheosis.lang("title", "world_tier_tutorial", new Object[0])));
        }
    }

    public void renderBackground(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(gfx, mouseX, mouseY, partialTick);
        int imgLeft = (this.width - 498) / 2;
        int imgTop = (this.height - 286) / 2;
        gfx.blit(TEXTURE, imgLeft, imgTop, 0.0f, 0.0f, 498, 286, 498, 286);
        PoseStack pose = gfx.pose();
        pose.pushPose();
        float scale = 3.0f;
        pose.scale(scale, scale, 1.0f);
        MutableComponent title = Apotheosis.lang("text", "world_tier." + this.displayedTier.getSerializedName(), new Object[0]);
        gfx.drawString(this.font, title.getVisualOrderText(), (float)(this.leftPos + 15) / scale, (float)(this.topPos + 15) / scale, 0xFFFFFF, true);
        pose.popPose();
        MutableComponent desc = Apotheosis.lang("text", "world_tier." + this.displayedTier.getSerializedName() + ".desc", new Object[0]);
        gfx.drawString(this.font, (Component)desc, this.leftPos + 15, this.topPos + 45, 13158510);
        gfx.blit(SEPARATOR_LINE, this.leftPos, this.topPos + 50, 0, 0.0f, 0.0f, 275, 30, 275, 30);
        MutableComponent diffText = Component.literal((String)"Difficulty:").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED});
        gfx.drawString(this.font, diffText.getVisualOrderText(), this.leftPos + 15, this.topPos + 80, 0xFFFFFF, true);
        pose.pushPose();
        scale = 0.5f;
        pose.scale(scale, scale, 1.0f);
        for (int i = 0; i < 5; ++i) {
            ResourceLocation tex = this.displayedTier.ordinal() >= i ? SWORD_FULL : SWORD_EMPTY;
            int swordLeft = this.leftPos + this.font.width((FormattedText)diffText) + 20 + i * (int)(30.0f * scale);
            gfx.blit(tex, (int)((float)swordLeft / scale), (int)((float)(this.topPos + 77) / scale), 0, 0.0f, 0.0f, 30, 30, 30, 30);
        }
        pose.popPose();
        AnimationData anim = switch (this.displayedTier) {
            default -> throw new MatchException(null, null);
            case WorldTier.HAVEN -> HAVEN_ANIMATION;
            case WorldTier.FRONTIER -> FRONTIER_ANIMATION;
            case WorldTier.ASCENT -> ASCENT_ANIMATION;
            case WorldTier.SUMMIT -> SUMMIT_ANIMATION;
            case WorldTier.PINNACLE -> PINNACLE_ANIMATION;
        };
        anim.render(gfx, this.leftPos, this.topPos, this.animTicks, partialTick);
    }

    public void tick() {
        ++this.animTicks;
    }

    protected Button.OnPress displayTier(WorldTier tier) {
        return btn -> {
            this.displayedTier = tier;
            this.updateButtonStatus();
            this.animTicks = 0;
        };
    }

    private Button.OnPress activateSelectedTier() {
        return btn -> {
            WorldTier tier = this.displayedTier;
            if (WorldTier.getTier((Player)Minecraft.getInstance().player) != tier || WorldTier.isTutorialActive((Player)Minecraft.getInstance().player)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new WorldTierPayload(tier), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.minecraft.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
            }
            btn.active = false;
            this.activateButton.setButtonText((Component)Apotheosis.lang("button", "activated", new Object[0]).withColor(10118812));
            this.activateButton.setMessage((Component)Apotheosis.lang("button", "already_activated", new Object[0]).withStyle(ChatFormatting.RED));
        };
    }

    protected Button.OnPress openDetailedInfoScreen() {
        return btn -> Minecraft.getInstance().pushGuiLayer((Screen)new WorldTierDetailScreen(this.displayedTier));
    }

    void closeTutorial() {
        if (this.activateButton.isActive()) {
            this.activateButton.onPress();
        }
    }

    protected void updateButtonStatus() {
        LocalPlayer player = Minecraft.getInstance().player;
        for (WorldTier tier : WorldTier.values()) {
            SimpleTexButton button = this.tierButtons.get((Object)tier);
            if (WorldTier.isUnlocked((Player)player, tier)) {
                button.active = true;
                button.setMessage((Component)Apotheosis.lang("button", tier.getSerializedName(), new Object[0]));
            } else {
                button.active = false;
                button.setMessage((Component)Apotheosis.lang("button", "tier_locked", Apotheosis.lang("button", tier.getSerializedName(), new Object[0])).withStyle(ChatFormatting.RED));
            }
            button.forceHovered = this.displayedTier == tier;
        }
        boolean bl = this.activateButton.active = WorldTier.getTier((Player)player) != this.displayedTier;
        if (WorldTier.isTutorialActive((Player)player) && this.displayedTier == WorldTier.HAVEN) {
            this.activateButton.active = WorldTier.isUnlocked((Player)player, this.displayedTier);
        }
        if (this.activateButton.active) {
            this.activateButton.setButtonText((Component)Apotheosis.lang("button", "activate", new Object[0]).withColor(0xFAA8FF));
            MutableComponent tierName = Apotheosis.lang("text", "world_tier." + this.displayedTier.getSerializedName(), new Object[0]).withStyle(ChatFormatting.GOLD);
            this.activateButton.setMessage((Component)Apotheosis.lang("button", "activate_tier", tierName));
        } else if (WorldTier.isTutorialActive((Player)player) && !WorldTier.isUnlocked((Player)player, this.displayedTier)) {
            this.activateButton.setButtonText((Component)Apotheosis.lang("button", "inactive", new Object[0]).withStyle(ChatFormatting.RED));
            this.activateButton.setMessage((Component)Apotheosis.lang("button", "locked", new Object[0]).withStyle(ChatFormatting.RED));
        } else {
            this.activateButton.setButtonText((Component)Apotheosis.lang("button", "activated", new Object[0]).withColor(10118812));
            this.activateButton.setMessage((Component)Apotheosis.lang("button", "already_activated", new Object[0]).withStyle(ChatFormatting.RED));
        }
    }

    private void addTierButton(WorldTier tier, UnaryOperator<SimpleTexButton.Builder> config) {
        SimpleTexButton button = ((SimpleTexButton.Builder)config.apply(SimpleTexButton.builder().size(30, 30).texture(Apotheosis.loc("textures/gui/buttons/" + tier.getSerializedName() + ".png")).texSize(30, 90).action(this.displayTier(tier)).message((Component)Apotheosis.lang("button", tier.getSerializedName(), new Object[0])).inactiveMessage(WorldTierSelectScreen.tierLocked(tier)))).build();
        this.tierButtons.put(tier, button);
        this.addRenderableWidget((GuiEventListener)button);
    }

    private static List<Component> tierLocked(WorldTier tier) {
        ClientAdvancements advancements = Minecraft.getInstance().getConnection().getAdvancements();
        AdvancementHolder advancement = advancements.get(Apotheosis.loc("progression/" + tier.getSerializedName()));
        ArrayList<Component> list = new ArrayList<Component>();
        MutableComponent advName = Apotheosis.lang("advancements", "progression." + tier.getSerializedName() + ".title", new Object[0]).withStyle(ChatFormatting.GOLD);
        if (advancement == null) {
            list.add((Component)Apotheosis.lang("button", "tier_advancement", advName.withStyle(ChatFormatting.OBFUSCATED)).withStyle(ChatFormatting.RED));
            list.add(CommonComponents.SPACE);
            for (int i = 0; i < 3; ++i) {
                list.add((Component)Apotheosis.lang("info", "criteria_unknown", Component.literal((String)"Do something, idk").withStyle(ChatFormatting.OBFUSCATED)).withStyle(ChatFormatting.GRAY));
            }
            return list;
        }
        list.add((Component)Apotheosis.lang("button", "tier_advancement", advName).withStyle(ChatFormatting.RED));
        list.add(CommonComponents.SPACE);
        AdvancementProgress progress = (AdvancementProgress)advancements.progress.get(advancement);
        for (String criteria : progress.criteria.keySet()) {
            MutableComponent critDesc;
            CriterionProgress critProg = (CriterionProgress)progress.criteria.get(criteria);
            if (critProg.isDone()) {
                critDesc = Apotheosis.lang("advancements", "progression." + tier.getSerializedName() + ".criteria." + criteria, new Object[0]).withStyle(ChatFormatting.GREEN);
                list.add((Component)Apotheosis.lang("info", "criteria_done", critDesc));
                continue;
            }
            critDesc = Apotheosis.lang("advancements", "progression." + tier.getSerializedName() + ".criteria." + criteria, new Object[0]).withStyle(ChatFormatting.GRAY);
            list.add((Component)Apotheosis.lang("info", "criteria_unfinished", critDesc));
        }
        return list;
    }

    @Nullable
    private static AdvancementHolder getTierAdvancement(WorldTier tier) {
        return Minecraft.getInstance().getConnection().getAdvancements().get(Apotheosis.loc("progression/" + tier.getSerializedName()));
    }

    private record AnimationData(int x, int y, int width, int height, int frames, ResourceLocation texture) {
        private void render(GuiGraphics gfx, int left, int top, int time, float partialTick) {
            int frameHeight = this.height / this.frames;
            int frame = (int)(((float)time + partialTick) / 2.0f);
            if (frame >= this.frames) {
                return;
            }
            RenderSystem.enableBlend();
            gfx.blit(this.texture, left + this.x, top + this.y, 0.0f, ((float)frame + 1.0f) * (float)frameHeight, this.width, frameHeight, this.width, this.height);
        }
    }
}

