/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AttributeProvidingAffix;
import dev.shadowsoffire.apotheosis.affix.augmenting.AugmentingScreen;
import dev.shadowsoffire.apotheosis.affix.augmenting.AugmentingTableTileRenderer;
import dev.shadowsoffire.apotheosis.affix.effect.StoneformingAffix;
import dev.shadowsoffire.apotheosis.affix.reforging.ReforgingScreen;
import dev.shadowsoffire.apotheosis.affix.reforging.ReforgingTableTileRenderer;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingScreen;
import dev.shadowsoffire.apotheosis.client.AdventureKeys;
import dev.shadowsoffire.apotheosis.client.GemModel;
import dev.shadowsoffire.apotheosis.client.RadialProgressTracker;
import dev.shadowsoffire.apotheosis.client.RarityParticle;
import dev.shadowsoffire.apotheosis.client.SocketTooltipRenderer;
import dev.shadowsoffire.apotheosis.client.StoneformingTooltipRenderer;
import dev.shadowsoffire.apotheosis.item.PotionCharmItem;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.mixin.client.GuiGraphicsAccessor;
import dev.shadowsoffire.apotheosis.net.BossSpawnPayload;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingScreen;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.apotheosis.util.EquipmentComparePositioner;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.GatherSkippedAttributeTooltipsEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Vector2i;
import org.joml.Vector2ic;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="apotheosis", value={Dist.CLIENT})
public class AdventureModuleClient {
    public static final int COMPARE_PADDING = 18;
    private static final List<BossSpawnPayload.BossSpawnData> BOSS_SPAWNS = new ArrayList<BossSpawnPayload.BossSpawnData>();
    private static final Component GEM_SOCKET_MARKER = Component.literal((String)"APOTH_SOCKET_MARKER");

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {
            BlockEntityRenderers.register(Apoth.Tiles.REFORGING_TABLE, k -> new ReforgingTableTileRenderer());
            BlockEntityRenderers.register(Apoth.Tiles.AUGMENTING_TABLE, k -> new AugmentingTableTileRenderer());
            ItemProperties.register((Item)((Item)Apoth.Items.GEM.value()), (ResourceLocation)Apotheosis.loc("purity"), (stack, level, entity, tint) -> {
                DynamicHolder<Gem> gem = GemItem.getGem(stack);
                Purity purity = GemItem.getPurity(stack);
                return gem.isBound() ? (float)purity.ordinal() : Float.NEGATIVE_INFINITY;
            });
            ItemProperties.register((Item)((Item)Apoth.Items.POTION_CHARM.value()), (ResourceLocation)Apotheosis.loc("enabled"), (stack, level, entity, tint) -> (Boolean)stack.getOrDefault(Apoth.Components.CHARM_ENABLED, (Object)false) != false ? 1.0f : 0.0f);
        });
        NeoForge.EVENT_BUS.register(AdventureKeys.class);
        NeoForge.EVENT_BUS.register(GameBusEvents.class);
        NeoForge.EVENT_BUS.register(RadialProgressTracker.class);
    }

    @SubscribeEvent
    public static void screens(RegisterMenuScreensEvent e) {
        e.register(Apoth.Menus.REFORGING, ReforgingScreen::new);
        e.register(Apoth.Menus.SALVAGE, SalvagingScreen::new);
        e.register(Apoth.Menus.GEM_CUTTING, GemCuttingScreen::new);
        e.register(Apoth.Menus.AUGMENTING, AugmentingScreen::new);
    }

    @SubscribeEvent
    public static void models(ModelEvent.RegisterAdditional e) {
        e.register(ReforgingTableTileRenderer.HAMMER);
        e.register(AugmentingTableTileRenderer.STAR_CUBE);
    }

    @SubscribeEvent
    public static void tooltipComps(RegisterClientTooltipComponentFactoriesEvent e) {
        e.register(SocketTooltipRenderer.SocketComponent.class, SocketTooltipRenderer::new);
        e.register(StoneformingTooltipRenderer.StoneformingComponent.class, StoneformingTooltipRenderer::new);
    }

    @SubscribeEvent
    public static void addGemModels(ModelEvent.RegisterAdditional e) {
        Set locs = Minecraft.getInstance().getResourceManager().listResources("models", loc -> "apotheosis".equals(loc.getNamespace()) && loc.getPath().contains("/gems/") && loc.getPath().endsWith(".json")).keySet();
        for (ResourceLocation s : locs) {
            String path = s.getPath().substring("models/".length(), s.getPath().length() - ".json".length());
            e.register(ModelResourceLocation.standalone((ResourceLocation)Apotheosis.loc(path)));
        }
    }

    @SubscribeEvent
    public static void replaceGemModel(ModelEvent.ModifyBakingResult e) {
        ModelResourceLocation key = new ModelResourceLocation(Apotheosis.loc("gem"), "inventory");
        BakedModel oldModel = (BakedModel)e.getModels().get(key);
        if (oldModel != null) {
            e.getModels().put(key, new GemModel(oldModel, e.getModelBakery()));
        }
    }

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), Apotheosis.loc("gray"), DefaultVertexFormat.NEW_ENTITY), shaderInstance -> {
            CustomRenderTypes.grayShader = shaderInstance;
        });
    }

    @SubscribeEvent
    public static void keys(RegisterKeyMappingsEvent e) {
        e.register(AdventureKeys.TOGGLE_RADIAL);
        e.register(AdventureKeys.OPEN_WORLD_TIER_SELECT);
        e.register(AdventureKeys.LINK_ITEM_TO_CHAT);
        e.register(AdventureKeys.COMPARE_EQUIPMENT);
    }

    @SubscribeEvent
    public static void colors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tint) -> tint == 0 ? -1 : FastColor.ARGB32.opaque((int)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor()), new ItemLike[]{(ItemLike)Apoth.Items.POTION_CHARM.value()});
    }

    @SubscribeEvent
    public static void factories(RegisterParticleProvidersEvent e) {
        e.registerSprite(Apoth.Particles.RARITY_GLOW, RarityParticle::new);
    }

    public static void onBossSpawn(BlockPos pos, int color) {
        BOSS_SPAWNS.add(new BossSpawnPayload.BossSpawnData(pos, color, new MutableInt()));
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(SoundEvents.END_PORTAL_SPAWN, SoundSource.HOSTILE, AdventureConfig.bossAnnounceVolume, 1.25f, Minecraft.getInstance().player.getRandom(), Minecraft.getInstance().player.blockPosition()));
    }

    public static void checkAffixLangKeys() {
        if (DatagenModLoader.isRunningDataGen()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Missing Affix Lang Keys:\n");
        boolean any = false;
        String json = "\"%s\": \"\",";
        for (Affix a : AffixRegistry.INSTANCE.getValues()) {
            ResourceLocation id = AffixRegistry.INSTANCE.getKey(a);
            if (!I18n.exists((String)("affix." + String.valueOf(id)))) {
                sb.append(json.formatted("affix." + String.valueOf(id)) + "\n");
                any = true;
            }
            if (I18n.exists((String)("affix." + String.valueOf(id) + ".suffix"))) continue;
            sb.append(json.formatted("affix." + String.valueOf(id) + ".suffix") + "\n");
            any = true;
        }
        if (any) {
            Apotheosis.LOGGER.error(sb.toString());
        }
    }

    public static AttributeTooltipContext tooltipCtx() {
        return AttributeTooltipContext.of((Player)Minecraft.getInstance().player, (Item.TooltipContext)Item.TooltipContext.of((Level)Minecraft.getInstance().level), (TooltipFlag)ApothicAttributes.getTooltipFlag());
    }

    public static RenderType gray(ResourceLocation texture) {
        return CustomRenderTypes.GRAY.apply(texture);
    }

    public static class GameBusEvents {
        @SubscribeEvent
        public static void login(ClientPlayerNetworkEvent.LoggingIn e) {
            e.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
        }

        @SubscribeEvent
        public static void render(RenderLevelStageEvent e) {
            if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                return;
            }
            PoseStack stack = e.getPoseStack();
            LocalPlayer p = Minecraft.getInstance().player;
            MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
            for (BossSpawnPayload.BossSpawnData data : BOSS_SPAWNS) {
                stack.pushPose();
                float partials = e.getPartialTick().getGameTimeDeltaPartialTick(false);
                Vec3 vec = e.getCamera().getPosition();
                stack.translate(-vec.x, -vec.y, -vec.z);
                stack.translate((float)data.pos().getX(), (float)data.pos().getY(), (float)data.pos().getZ());
                BeaconRenderer.renderBeaconBeam((PoseStack)stack, (MultiBufferSource)buf, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)partials, (float)1.0f, (long)p.level().getGameTime(), (int)0, (int)64, (int)data.color(), (float)0.166f, (float)0.33f);
                stack.popPose();
            }
        }

        @SubscribeEvent
        public static void time(ClientTickEvent.Post e) {
            for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
                BossSpawnPayload.BossSpawnData data = BOSS_SPAWNS.get(i);
                if (data.ticks().getAndIncrement() <= 400) continue;
                BOSS_SPAWNS.remove(i--);
            }
        }

        @SubscribeEvent
        public static void tooltips(AddAttributeTooltipsEvent e) {
            ItemStack stack = e.getStack();
            int sockets = SocketHelper.getSockets(stack);
            if (sockets > 0 && !WorldTier.isTutorialActive((Player)Minecraft.getInstance().player)) {
                e.addTooltipLines(new Component[]{GEM_SOCKET_MARKER.copy()});
            }
        }

        @SubscribeEvent
        public static void ignoreSocketUUIDS(GatherSkippedAttributeTooltipsEvent e) {
            ItemStack stack = e.getStack();
            for (GemInstance gem : SocketHelper.getGems(stack)) {
                if (!gem.isValid()) continue;
                gem.skipModifierIds(arg_0 -> ((GatherSkippedAttributeTooltipsEvent)e).skipId(arg_0));
            }
            AffixHelper.streamAffixes(stack).forEach(inst -> {
                Affix patt0$temp = inst.getAffix();
                if (patt0$temp instanceof AttributeProvidingAffix) {
                    AttributeProvidingAffix afx = (AttributeProvidingAffix)((Object)patt0$temp);
                    afx.skipModifierIds((AffixInstance)inst, e.getContext(), arg_0 -> ((GatherSkippedAttributeTooltipsEvent)e).skipId(arg_0));
                }
            });
        }

        @SubscribeEvent
        public static void comps(RenderTooltipEvent.GatherComponents e) {
            List list = e.getTooltipElements();
            for (int i = 0; i < list.size(); ++i) {
                Either entry = (Either)list.get(i);
                if (GameBusEvents.containsMarker((Either<FormattedText, TooltipComponent>)entry, GEM_SOCKET_MARKER)) {
                    list.remove(i);
                    list.add(i, Either.right((Object)new SocketTooltipRenderer.SocketComponent(e.getItemStack(), SocketHelper.getGems(e.getItemStack()))));
                    continue;
                }
                if (!GameBusEvents.containsMarker((Either<FormattedText, TooltipComponent>)entry, StoneformingAffix.TOOLTIP_MARKER)) continue;
                list.remove(i);
                AffixInstance inst = AffixHelper.streamAffixes(e.getItemStack()).filter(a -> a.getAffix() instanceof StoneformingAffix).findFirst().orElse(null);
                if (inst == null) continue;
                list.add(i, Either.right((Object)new StoneformingTooltipRenderer.StoneformingComponent(inst)));
            }
        }

        private static boolean containsMarker(Either<FormattedText, TooltipComponent> entry, Component marker) {
            Component comp;
            Object t;
            Optional o = entry.left();
            return o.isPresent() && (t = o.get()) instanceof Component && (comp = (Component)t).contains(marker);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void affixTooltips(ItemTooltipEvent e) {
            MutableComponent desc;
            ItemStack stack = e.getItemStack();
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            AttributeTooltipContext ctx = AttributeTooltipContext.of((Player)Minecraft.getInstance().player, (Item.TooltipContext)e.getContext(), (TooltipFlag)e.getFlags());
            if (e.getEntity() != null && WorldTier.isTutorialActive(e.getEntity())) {
                if (stack.has(Apoth.Components.AFFIXES) || stack.has(Apoth.Components.SOCKETS) || stack.has(Apoth.Components.RARITY)) {
                    e.getToolTip().add(1, Apotheosis.lang("text", "world_tier_tutorial", new Object[0]).withStyle(ChatFormatting.YELLOW));
                    e.getToolTip().add(2, Apotheosis.lang("text", "world_tier_tutorial.2", AdventureKeys.OPEN_WORLD_TIER_SELECT.getTranslatedKeyMessage()).withStyle(ChatFormatting.YELLOW));
                }
                return;
            }
            if (stack.has(Apoth.Components.AFFIXES)) {
                AffixHelper.streamAffixes(stack).sorted(Comparator.comparingInt(a -> a.getAffix().definition().type().ordinal())).forEach(inst -> {
                    MutableComponent desc = inst.getDescription(ctx);
                    if (desc.getContents() != PlainTextContents.EMPTY) {
                        if (inst.level() > 1.0f) {
                            components.add(ApothMiscUtil.starPrefix((Component)desc).withStyle(ChatFormatting.YELLOW));
                        } else {
                            components.add(ApothMiscUtil.dotPrefix((Component)desc).withStyle(ChatFormatting.YELLOW));
                        }
                    }
                });
            }
            if (stack.has(Apoth.Components.DURABILITY_BONUS) && !stack.has(DataComponents.UNBREAKABLE)) {
                desc = Component.translatable((String)"affix.apotheosis:durable.desc", (Object[])new Object[]{Math.round(100.0f * ((Float)stack.get(Apoth.Components.DURABILITY_BONUS)).floatValue())});
                components.add(ApothMiscUtil.dotPrefix((Component)desc).withStyle(ChatFormatting.YELLOW));
            }
            if (((Boolean)stack.getOrDefault(Apoth.Components.MALICE_MARKER, (Object)false)).booleanValue()) {
                desc = Apotheosis.lang("text", "malice_marker", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE});
                components.add(desc);
            }
            if (((Boolean)stack.getOrDefault(Apoth.Components.TOUCHED_BY_MALICE, (Object)false)).booleanValue()) {
                desc = Apotheosis.lang("text", "touched_by_malice", new Object[0]);
                components.add(ApothMiscUtil.dotPrefix((Component)desc).withStyle(ChatFormatting.RED));
            }
            if (!components.isEmpty()) {
                e.getToolTip().addAll(1, components);
            }
            HashSet special = new HashSet();
            AffixHelper.streamAffixes(stack).filter(inst -> inst.level() > 1.0f).filter(inst -> inst.getAffix() instanceof AttributeProvidingAffix).forEach(inst -> ((AttributeProvidingAffix)((Object)inst.getAffix())).gatherModifierTooltips((AffixInstance)inst, ctx, special::add));
            List tooltips = e.getToolTip();
            MutableComponent listHeader = Component.literal((String)" \u2507 ").withStyle(ChatFormatting.GRAY);
            if (!special.isEmpty()) {
                for (int i = 0; i < tooltips.size(); ++i) {
                    Component child;
                    Component comp = (Component)tooltips.get(i);
                    if (special.contains(comp)) {
                        tooltips.remove(i);
                        tooltips.add(i, ApothMiscUtil.starPrefix(comp).withStyle(comp.getStyle()));
                        continue;
                    }
                    if (!comp.getContents().equals((Object)listHeader.getContents()) || comp.getSiblings().size() != 1 || !special.contains(child = (Component)comp.getSiblings().get(0))) continue;
                    tooltips.remove(i);
                    MutableComponent replacement = listHeader.copy();
                    replacement.append((Component)ApothMiscUtil.starPrefix(child).withStyle(child.getStyle()));
                    for (int j = 1; j < comp.getSiblings().size(); ++j) {
                        replacement.append((Component)comp.getSiblings().get(j));
                    }
                    tooltips.add(i, replacement);
                }
            }
        }

        @SubscribeEvent
        public static void showBlacklistedPotions(ItemTooltipEvent e) {
            Holder potion;
            if (e.getItemStack().getItem() == Items.POTION && !PotionCharmItem.isValidPotion((Holder<Potion>)(potion = ((PotionContents)e.getItemStack().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().orElse(Potions.WATER)))) {
                e.getToolTip().add(Component.translatable((String)"misc.apotheosis.blacklisted_potion").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        }

        @SubscribeEvent
        public static void renderCanSocketTooltip(ScreenEvent.Render.Post e) {
            Screen screen = e.getScreen();
            if (screen instanceof AbstractContainerScreen) {
                ItemStack hover;
                AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                ItemStack carried = screen2.getMenu().getCarried();
                ItemStack itemStack = hover = screen2.getSlotUnderMouse() == null ? ItemStack.EMPTY : screen2.getSlotUnderMouse().getItem();
                if (carried.is(Apoth.Items.GEM) && SocketHelper.canSocketGemInItem(hover, carried)) {
                    GuiGraphics gfx = e.getGuiGraphics();
                    ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                    MutableComponent itemName = Component.translatable((String)"%s", (Object[])new Object[]{hover.getHoverName()}).withStyle(ChatFormatting.WHITE);
                    tooltip.add(Apotheosis.lang("misc", "right_click_to_socket", carried.getHoverName(), itemName).withStyle(ChatFormatting.GRAY));
                    gfx.pose().pushPose();
                    gfx.pose().translate(0.0f, 0.0f, 400.0f);
                    e.getGuiGraphics().renderComponentTooltip(Minecraft.getInstance().font, tooltip, e.getMouseX(), e.getMouseY());
                    gfx.pose().popPose();
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void compareItems(RenderTooltipEvent.Pre e) {
            if (!AdventureConfig.enableEquipmentCompare) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (!InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)AdventureKeys.COMPARE_EQUIPMENT.getKey().getValue()) || !(mc.screen instanceof AbstractContainerScreen)) {
                return;
            }
            Slot slot = ((AbstractContainerScreen)mc.screen).getSlotUnderMouse();
            if (slot == null || !slot.hasItem() || slot.getItem() != e.getItemStack()) {
                return;
            }
            ItemStack stack = e.getItemStack();
            LootCategory cat = LootCategory.forItem(stack);
            if (cat.isNone()) {
                return;
            }
            LocalPlayer player = mc.player;
            Item item = stack.getItem();
            if (item instanceof Equipable) {
                Equipable equip = (Equipable)item;
                EquipmentSlot equipmentSlot = equip.getEquipmentSlot();
                ItemStack equipped = player.getItemBySlot(equipmentSlot);
                if (!equipped.isEmpty() && stack != equipped) {
                    GameBusEvents.tryRenderComparison(e, mc, equipped);
                }
            } else {
                ItemStack equipped;
                LootCategory equippedCat;
                if (cat.getSlots().test(ALObjects.EquipmentSlots.MAINHAND) && (equippedCat = LootCategory.forItem(equipped = player.getMainHandItem())) == cat && stack != equipped) {
                    GameBusEvents.tryRenderComparison(e, mc, equipped);
                    return;
                }
                if (cat.getSlots().test(ALObjects.EquipmentSlots.OFFHAND) && (equippedCat = LootCategory.forItem(equipped = player.getOffhandItem())) == cat && stack != equipped) {
                    GameBusEvents.tryRenderComparison(e, mc, equipped);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean tryRenderComparison(RenderTooltipEvent.Pre e, Minecraft mc, ItemStack equipped) {
            Font font = e.getFont();
            GuiGraphics gfx = e.getGraphics();
            GuiGraphicsAccessor acc = (GuiGraphicsAccessor)gfx;
            ClientTooltipPositioner positioner = e.getTooltipPositioner();
            List equipLines = Screen.getTooltipFromItem((Minecraft)mc, (ItemStack)equipped);
            int scnWidth = e.getScreenWidth();
            int scnHeight = e.getScreenHeight();
            List compList = e.getComponents();
            int compWidth = -1;
            int compHeight = 0;
            for (ClientTooltipComponent comp : compList) {
                compWidth = Math.max(compWidth, comp.getWidth(font));
                compHeight += comp.getHeight();
            }
            Vector2ic compPos = positioner.positionTooltip(scnWidth, scnHeight, e.getX(), e.getY(), compWidth, compHeight);
            List equipList = ClientHooks.gatherTooltipComponents((ItemStack)equipped, (List)equipLines, (Optional)equipped.getTooltipImage(), (int)0, (int)(gfx.guiWidth() - compWidth - 36), (int)gfx.guiHeight(), (Font)font);
            int equipWidth = -1;
            int equipHeight = 0;
            for (ClientTooltipComponent comp : equipList) {
                equipWidth = Math.max(equipWidth, comp.getWidth(font));
                equipHeight += comp.getHeight();
            }
            EquipmentComparePositioner realPositioner = new EquipmentComparePositioner(scnWidth, scnHeight);
            Vector2i equipPos = new Vector2i(compPos.x() - 18 - equipWidth, compPos.y());
            boolean canRender = realPositioner.position((Vector2ic)equipPos, equipWidth + 6, equipHeight + 6, compPos, compWidth + 6, compHeight + 6);
            if (canRender) {
                try {
                    e.setCanceled(true);
                    GameBusEvents.renderTooltipInternalNoEvent(gfx, font, compList, (Vector2ic)realPositioner.getComparePos());
                    Vector2i newEquipPos = realPositioner.getEquippedPos();
                    acc.setTooltipStack(equipped);
                    GameBusEvents.renderTooltipInternalNoEvent(gfx, font, equipList, (Vector2ic)newEquipPos);
                    acc.setTooltipStack(ItemStack.EMPTY);
                    MutableComponent equippedTxt = Apotheosis.lang("text", "equipped", new Object[0]);
                    int txtWidth = font.width((FormattedText)equippedTxt);
                    int txtX = newEquipPos.x() + equipWidth / 2 - txtWidth / 2;
                    int n = newEquipPos.y();
                    Objects.requireNonNull(font);
                    int txtY = n - 9 - 10;
                    PoseStack pose = gfx.pose();
                    pose.pushPose();
                    int bgColor = -15461346;
                    int borderTop = -279028343;
                    int borderBot = -281462444;
                    int n2 = font.width((FormattedText)equippedTxt) + 30;
                    Objects.requireNonNull(font);
                    TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gfx, (int)(txtX - 15), (int)txtY, (int)n2, (int)9, (int)400, (int)-15461346, (int)-15461346, (int)-279028343, (int)-281462444);
                    pose.translate(0.0f, 0.0f, 400.0f);
                    gfx.drawString(font, (Component)equippedTxt, txtX, txtY, 0xFFFFFF);
                    pose.popPose();
                }
                finally {
                    acc.setTooltipStack(e.getItemStack());
                }
                return true;
            }
            return false;
        }

        private static void renderTooltipInternalNoEvent(GuiGraphics gfx, Font font, List<ClientTooltipComponent> components, Vector2ic pos) {
            if (!components.isEmpty()) {
                GuiGraphicsAccessor acc = (GuiGraphicsAccessor)gfx;
                int i = 0;
                int j = components.size() == 1 ? -2 : 0;
                for (ClientTooltipComponent clienttooltipcomponent : components) {
                    int k = clienttooltipcomponent.getWidth(font);
                    if (k > i) {
                        i = k;
                    }
                    j += clienttooltipcomponent.getHeight();
                }
                int i2 = i;
                int j2 = j;
                Vector2ic vector2ic = pos;
                int l = vector2ic.x();
                int i1 = vector2ic.y();
                gfx.pose().pushPose();
                RenderTooltipEvent.Color colorEvent = ClientHooks.onRenderTooltipColor((ItemStack)acc.getTooltipStack(), (GuiGraphics)gfx, (int)l, (int)i1, (Font)font, components);
                gfx.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gfx, (int)l, (int)i1, (int)i2, (int)j2, (int)400, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundEnd(), (int)colorEvent.getBorderStart(), (int)colorEvent.getBorderEnd()));
                gfx.pose().translate(0.0f, 0.0f, 400.0f);
                int k1 = i1;
                for (int l1 = 0; l1 < components.size(); ++l1) {
                    ClientTooltipComponent clienttooltipcomponent1 = components.get(l1);
                    clienttooltipcomponent1.renderText(font, l, k1, gfx.pose().last().pose(), gfx.bufferSource());
                    k1 += clienttooltipcomponent1.getHeight() + (l1 == 0 ? 2 : 0);
                }
                k1 = i1;
                for (int k2 = 0; k2 < components.size(); ++k2) {
                    ClientTooltipComponent clienttooltipcomponent2 = components.get(k2);
                    clienttooltipcomponent2.renderImage(font, l, k1, gfx);
                    k1 += clienttooltipcomponent2.getHeight() + (k2 == 0 ? 2 : 0);
                }
                gfx.pose().popPose();
            }
        }
    }

    private static class CustomRenderTypes
    extends RenderType {
        private static ShaderInstance grayShader;
        private static final RenderStateShard.ShaderStateShard RENDER_TYPE_GRAY;
        public static Function<ResourceLocation, RenderType> GRAY;

        private static RenderType gray(ResourceLocation loc) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setShaderState(RENDER_TYPE_GRAY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(loc, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).createCompositeState(true);
            return CustomRenderTypes.create((String)"gray", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$state);
        }

        private CustomRenderTypes(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
            super(s, v, m, i, b, b2, r, r2);
            throw new IllegalStateException("This class is not meant to be constructed!");
        }

        static {
            RENDER_TYPE_GRAY = new RenderStateShard.ShaderStateShard(() -> grayShader);
            GRAY = Util.memoize(CustomRenderTypes::gray);
        }
    }
}

