/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.attachments;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record BonusLootTables(List<ResourceKey<LootTable>> tables) {
    public static final BonusLootTables EMPTY = new BonusLootTables(List.of());
    public static final Codec<BonusLootTables> CODEC = ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).listOf().xmap(BonusLootTables::new, BonusLootTables::tables);

    public void drop(Mob owner, DamageSource source, boolean hitByPlayer) {
        for (ResourceKey<LootTable> key : this.tables) {
            LootTable table = owner.level().getServer().reloadableRegistries().getLootTable(key);
            if (table == LootTable.EMPTY) continue;
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)owner.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)owner).withParameter(LootContextParams.ORIGIN, (Object)owner.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
            if (hitByPlayer && owner.lastHurtByPlayer != null) {
                lootparams$builder = lootparams$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)owner.lastHurtByPlayer).withLuck(owner.lastHurtByPlayer.getLuck());
            }
            LootParams lootparams = lootparams$builder.create(LootContextParamSets.ENTITY);
            table.getRandomItems(lootparams, owner.getLootTableSeed(), arg_0 -> ((Mob)owner).spawnAtLocation(arg_0));
        }
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public BonusLootTables mergeWith(BonusLootTables other) {
        ArrayList<ResourceKey<LootTable>> combined = new ArrayList<ResourceKey<LootTable>>();
        combined.addAll(this.tables);
        combined.addAll(other.tables);
        return new BonusLootTables(combined);
    }
}

