/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class StoneformingAffix
extends Affix {
    public static final Codec<StoneformingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(StoneformingAffix.affixDef(), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("candidates").forGetter(a -> a.candidates)).apply((Applicative)inst, StoneformingAffix::new));
    public static final Component TOOLTIP_MARKER = Component.literal((String)"APOTH_STONEFORMING_MARKER");
    protected final Set<LootCategory> categories;
    protected final HolderSet<Block> candidates;

    public StoneformingAffix(AffixDefinition definition, Set<LootCategory> categories, HolderSet<Block> candidates) {
        super(definition);
        this.categories = categories;
        this.candidates = candidates;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return this.categories.contains(cat);
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return TOOLTIP_MARKER.copy();
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        return super.getDescription(inst, ctx);
    }

    @Override
    public void modifyLoot(AffixInstance inst, ObjectArrayList<ItemStack> loot, LootContext ctx) {
        Block block;
        if (ctx.hasParam(LootContextParams.BLOCK_STATE) && this.isCandidate(block = ((BlockState)ctx.getParam(LootContextParams.BLOCK_STATE)).getBlock())) {
            for (int i = 0; i < loot.size(); ++i) {
                BlockItem bi;
                Block lootBlock;
                ItemStack stack = (ItemStack)loot.get(i);
                Item item = stack.getItem();
                if (!(item instanceof BlockItem) || !this.isCandidate(lootBlock = (bi = (BlockItem)item).getBlock())) continue;
                loot.set(i, (Object)stack.transmuteCopy((ItemLike)this.getTarget(inst)));
            }
        }
    }

    @Override
    public InteractionResult onItemUse(AffixInstance inst, UseOnContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        Block block = state.getBlock();
        if (this.isCandidate(block) && this.getTarget(inst) != block && ctx.getPlayer().isShiftKeyDown()) {
            if (!ctx.getLevel().isClientSide) {
                inst.stack().set(Apoth.Components.STONEFORMING_TARGET, (Object)block);
                ctx.getPlayer().sendSystemMessage((Component)Apotheosis.lang("affix", "stoneforming.target_updated", block.getName()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUse(inst, ctx);
    }

    protected boolean isCandidate(Block block) {
        return this.candidates.contains(BuiltInRegistries.BLOCK.wrapAsHolder((Object)block));
    }

    public Block getTarget(AffixInstance inst) {
        Block target = (Block)inst.stack().get(Apoth.Components.STONEFORMING_TARGET);
        if (target == null || !this.isCandidate(target)) {
            return this.candidates.size() > 0 ? (Block)this.candidates.get(0).value() : Blocks.AIR;
        }
        return target;
    }

    public HolderSet<Block> getCandidates() {
        return this.candidates;
    }
}

