/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class PsychicAffix
extends Affix {
    public static final Codec<PsychicAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(PsychicAffix.affixDef(), (App)LootRarity.mapCodec(StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, PsychicAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public PsychicAffix(AffixDefinition def, Map<LootRarity, StepFunction> values) {
        super(def);
        this.values = values;
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{PsychicAffix.fmt(100.0f * this.getTrueLevel(inst))});
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        MutableComponent minComp = Component.translatable((String)"%s%%", (Object[])new Object[]{PsychicAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), 0.0f))});
        MutableComponent maxComp = Component.translatable((String)"%s%%", (Object[])new Object[]{PsychicAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), 1.0f))});
        return comp.append((Component)PsychicAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat == Apoth.LootCategories.SHIELD && this.values.containsKey(rarity);
    }

    @Override
    public float onShieldBlock(AffixInstance inst, LivingEntity entity, DamageSource source, float amount) {
        Projectile arrow;
        Entity owner;
        Entity entity2 = source.getDirectEntity();
        if (entity2 instanceof Projectile && (owner = (arrow = (Projectile)entity2).getOwner()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            living.hurt(entity.damageSources().source(Apoth.DamageTypes.PSYCHIC, (Entity)entity), amount * this.getTrueLevel(inst));
        }
        return super.onShieldBlock(inst, entity, source, amount);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    private float getTrueLevel(AffixInstance inst) {
        return this.getTrueLevel(inst.getRarity(), inst.level());
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }
}

