/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.OmneticUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class OmneticAffix
extends Affix {
    public static final Codec<OmneticAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(OmneticAffix.affixDef(), (App)LootRarity.mapCodec(OmneticUtil.OmneticData.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, OmneticAffix::new));
    protected final Map<LootRarity, OmneticUtil.OmneticData> values;

    public OmneticAffix(AffixDefinition def, Map<LootRarity, OmneticUtil.OmneticData> values) {
        super(def);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isBreaker() && this.values.containsKey(rarity);
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{Component.translatable((String)("misc.apotheosis." + this.values.get(inst.getRarity()).name()))});
    }

    public static void harvest(PlayerEvent.HarvestCheck e) {
        AffixInstance inst;
        ItemStack stack = e.getEntity().getMainHandItem();
        if (!stack.isEmpty() && (inst = (AffixInstance)AffixHelper.streamAffixes(stack).filter(i -> i.getAffix() instanceof OmneticAffix).findFirst().orElse(null)) != null && inst.isValid()) {
            OmneticUtil.OmneticData data = ((OmneticAffix)inst.getAffix()).values.get(inst.rarity().get());
            OmneticUtil.applyOmneticData(e, data);
        }
    }

    public static void speed(PlayerEvent.BreakSpeed e) {
        AffixInstance inst;
        ItemStack stack = e.getEntity().getMainHandItem();
        if (!stack.isEmpty() && (inst = (AffixInstance)AffixHelper.streamAffixes(stack).filter(i -> i.getAffix() instanceof OmneticAffix).findFirst().orElse(null)) != null && inst.isValid()) {
            OmneticUtil.OmneticData data = ((OmneticAffix)inst.getAffix()).values.get(inst.rarity().get());
            OmneticUtil.applyOmneticData(e, data);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static class Builder
    extends AffixBuilder<Builder> {
        private final Map<LootRarity, OmneticUtil.OmneticData> values = new HashMap<LootRarity, OmneticUtil.OmneticData>();

        public Builder value(LootRarity rarity, String name, Item ... items) {
            OmneticUtil.OmneticData data = new OmneticUtil.OmneticData(name, (ItemStack[])Arrays.stream(items).map(Item::getDefaultInstance).toArray(ItemStack[]::new));
            this.values.put(rarity, data);
            return this;
        }

        public OmneticAffix build() {
            Preconditions.checkNotNull((Object)this.definition);
            return new OmneticAffix(this.definition, this.values);
        }
    }
}

