/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mixin.LivingEntityInvoker;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class ExecutingAffix
extends Affix {
    public static final Codec<ExecutingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(ExecutingAffix.affixDef(), (App)LootRarity.mapCodec(StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, ExecutingAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public ExecutingAffix(AffixDefinition def, Map<LootRarity, StepFunction> values) {
        super(def);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isMelee() && this.values.containsKey(rarity);
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{ExecutingAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), inst.level()))});
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        MutableComponent minComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ExecutingAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), 0.0f))});
        MutableComponent maxComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ExecutingAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), 1.0f))});
        return comp.append((Component)ExecutingAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    @Override
    public void doPostAttack(AffixInstance inst, LivingEntity user, Entity target) {
        float threshold = this.getTrueLevel(inst.getRarity(), inst.level());
        if ((double)ApothicAttributes.getLocalAtkStrength((Entity)user) >= 0.98 && target instanceof LivingEntity) {
            DamageSource src;
            LivingEntity living = (LivingEntity)target;
            if (!living.level().isClientSide && living.getHealth() / living.getMaxHealth() < threshold && !((LivingEntityInvoker)living).callCheckTotemDeathProtection(src = living.damageSources().source(Apoth.DamageTypes.EXECUTE, (Entity)user))) {
                SoundEvent soundevent = ((LivingEntityInvoker)living).callGetDeathSound();
                if (soundevent != null) {
                    living.playSound(soundevent, ((LivingEntityInvoker)living).callGetSoundVolume(), living.getVoicePitch());
                }
                living.setLastHurtByMob(user);
                if (user instanceof Player) {
                    Player p = (Player)user;
                    living.setLastHurtByPlayer(p);
                }
                living.getCombatTracker().recordDamage(src, 99999.0f);
                living.setHealth(0.0f);
                living.die(src);
            }
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

