/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.augmenting;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class AugmentingTableTile
extends BlockEntity
implements TickingBlockEntity {
    public static int RISE_TIME = 30;
    public static int SPIN_CYCLE_TIME = 90;
    public int time = 0;
    public AnimationStage stage = AnimationStage.HIDING;
    protected InternalItemHandler inv = new InternalItemHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.is(Apoth.Items.SIGIL_OF_ENHANCEMENT);
        }

        protected void onContentsChanged(int slot) {
            AugmentingTableTile.this.setChanged();
        }
    };

    public AugmentingTableTile(BlockPos pPos, BlockState pBlockState) {
        super(Apoth.Tiles.AUGMENTING_TABLE, pPos, pBlockState);
    }

    public void clientTick(Level pLevel, BlockPos pPos, BlockState pState) {
        Player player = pLevel.getNearestPlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, 4.0, false);
        switch (this.stage.ordinal()) {
            case 0: {
                if (player == null) break;
                this.stage = AnimationStage.RISING;
                this.time = 0;
                break;
            }
            case 1: {
                if (player != null) {
                    ++this.time;
                    if (this.time < RISE_TIME) break;
                    this.stage = AnimationStage.SPINNING;
                    this.time = 0;
                    break;
                }
                this.stage = AnimationStage.FALLING;
                break;
            }
            case 2: {
                if (player != null) {
                    this.stage = AnimationStage.RISING;
                    break;
                }
                --this.time;
                if (this.time > 0) break;
                this.stage = AnimationStage.HIDING;
                this.time = 0;
                break;
            }
            case 3: {
                ++this.time;
                if (player != null || this.time % SPIN_CYCLE_TIME != 0) break;
                this.stage = AnimationStage.FALLING;
                this.time = RISE_TIME;
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.saveAdditional(tag, regs);
        tag.put("inventory", (Tag)this.inv.serializeNBT(regs));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        this.inv.deserializeNBT(regs, tag.getCompound("inventory"));
    }

    public IItemHandler getInventory() {
        return this.inv;
    }

    public static enum AnimationStage {
        HIDING,
        RISING,
        FALLING,
        SPINNING;

    }
}

