/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.ItemAffixes;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.extensions.IAttributeExtension;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.enchanting.GetEnchantmentLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public abstract class Affix
implements CodecProvider<Affix>,
TieredWeights.Weighted {
    public static final float MAX_LEVEL = 2.0f;
    public static final float STANDARD_MAX_LEVEL = 1.0f;
    protected final AffixDefinition definition;

    protected Affix(AffixDefinition definition) {
        this.definition = definition;
    }

    public abstract boolean canApplyTo(ItemStack var1, LootCategory var2, LootRarity var3);

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{Affix.fmt(inst.level())});
    }

    public Component getName(boolean prefix) {
        if (prefix) {
            return Component.translatable((String)("affix." + String.valueOf(this.id())));
        }
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".suffix"));
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        return this.getDescription(inst, ctx);
    }

    public void addModifiers(AffixInstance inst, StackAttributeModifiersEvent event) {
    }

    public float getDamageProtection(AffixInstance inst, DamageSource source) {
        return 0.0f;
    }

    public float getDamageBonus(AffixInstance inst, Entity entity) {
        return 0.0f;
    }

    public void doPostAttack(AffixInstance inst, LivingEntity user, Entity target) {
    }

    public void doPostHurt(AffixInstance inst, LivingEntity user, DamageSource source) {
    }

    public void onProjectileFired(AffixInstance inst, LivingEntity user, Projectile projectile) {
    }

    @Nullable
    public InteractionResult onItemUse(AffixInstance inst, UseOnContext ctx) {
        return null;
    }

    public void onProjectileImpact(float level, LootRarity rarity, Projectile proj, HitResult res, HitResult.Type type) {
    }

    public float onShieldBlock(AffixInstance inst, LivingEntity entity, DamageSource source, float amount) {
        return amount;
    }

    public void onBlockBreak(AffixInstance inst, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
    }

    public float getDurabilityBonusPercentage(AffixInstance inst) {
        return 0.0f;
    }

    public float onHurt(AffixInstance inst, DamageSource src, LivingEntity ent, float amount) {
        return amount;
    }

    public boolean enablesTelepathy() {
        return false;
    }

    public void getEnchantmentLevels(AffixInstance inst, GetEnchantmentLevelEvent event) {
    }

    public void modifyLoot(AffixInstance inst, ObjectArrayList<ItemStack> loot, LootContext ctx) {
    }

    public void modifyEntityLoot(AffixInstance inst, LivingDropsEvent event) {
    }

    public boolean isCompatibleWith(Affix affix) {
        return this != affix && !this.definition().exclusiveSet().contains(AffixRegistry.INSTANCE.holder(affix)) && !affix.definition().exclusiveSet().contains(AffixRegistry.INSTANCE.holder(this));
    }

    public boolean isCompatibleWith(ItemAffixes affixes) {
        return affixes.liveAffixes().allMatch(this::isCompatibleWith);
    }

    public String toString() {
        return String.format("Affix: %s", this.id());
    }

    public final AffixDefinition definition() {
        return this.definition;
    }

    @Override
    public final TieredWeights weights() {
        return this.definition.weights();
    }

    public final ResourceLocation id() {
        return AffixRegistry.INSTANCE.getKey(this);
    }

    public static boolean isOnCooldown(ResourceLocation id, int cooldown, LivingEntity entity) {
        long lastApplied = entity.getPersistentData().getLong("apoth.affix_cooldown." + id.toString());
        return lastApplied != 0L && lastApplied + (long)cooldown >= entity.level().getGameTime();
    }

    public static void startCooldown(ResourceLocation id, LivingEntity entity) {
        entity.getPersistentData().putLong("apoth.affix_cooldown." + id.toString(), entity.level().getGameTime());
    }

    public static String fmt(float f) {
        if (f == (float)((long)f)) {
            return String.format("%d", (long)f);
        }
        return IAttributeExtension.FORMAT.format(f);
    }

    public static MutableComponent valueBounds(Component min, Component max) {
        return CommonComponents.space().append((Component)Component.translatable((String)"misc.apotheosis.affix_bounds", (Object[])new Object[]{min, max}).withStyle(ChatFormatting.DARK_GRAY));
    }

    static ResourceLocation makeUniqueId(AffixInstance inst, String salt) {
        ResourceLocation key = inst.affix().getId();
        LootCategory cat = LootCategory.forItem(inst.stack());
        return ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)(key.getPath() + "_modifier_" + cat.getSlots().id().toShortLanguageKey() + "_" + salt));
    }

    static ResourceLocation makeUniqueId(AffixInstance inst) {
        return Affix.makeUniqueId(inst, "");
    }

    protected static <T extends Affix> App<RecordCodecBuilder.Mu<T>, AffixDefinition> affixDef() {
        return AffixDefinition.CODEC.fieldOf("definition").forGetter(Affix::definition);
    }
}

