/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.client.handler;

import fuzs.airhop.AirHop;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.handler.PlayerFallHandler;
import fuzs.airhop.init.ModRegistry;
import fuzs.airhop.network.client.ServerboundAirHopMessage;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class AirHopClientHandler {
    public static void onEndPlayerTick(Player player) {
        if (player.getAbilities().flying) {
            player.noJumpDelay = 10;
        } else if (player.jumping && player.noJumpDelay == 0 && AirHopClientHandler.attemptJump(player)) {
            player.noJumpDelay = 10;
            AirHop.NETWORK.sendToServer((ServerboundMessage)new ServerboundAirHopMessage());
        }
    }

    private static boolean attemptJump(Player player) {
        if (AirHopClientHandler.canJump(player) && AirHopClientHandler.isSaturated(player) && (Byte)ModRegistry.AIR_HOPS_ATTACHMENT_TYPE.getOrDefault((Object)player, (Object)0) < AirHopClientHandler.getHighestLevel((LivingEntity)player, (DataComponentType)ModRegistry.AIR_HOP_ENCHANTMENT_EFFECT_COMPONENT_TYPE.value())) {
            player.jumpFromGround();
            player.resetFallDistance();
            ModRegistry.AIR_HOPS_ATTACHMENT_TYPE.update((Object)player, airHops -> {
                airHops = (byte)(airHops + 1);
                return airHops;
            });
            return true;
        }
        return false;
    }

    private static boolean canJump(Player player) {
        if (!(player.onGround() || ((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).fallingOnly && !(PlayerFallHandler.getJumpHeight(player) / 2.0f < player.fallDistance) || player.isPassenger() || player.getAbilities().flying || player.onClimbable())) {
            return !player.isInWater() && !player.isInLava();
        }
        return false;
    }

    private static boolean isSaturated(Player player) {
        return player.getAbilities().mayfly || !((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).disableOnHungry || player.getFoodData().getFoodLevel() > 6;
    }

    private static <T> int getHighestLevel(LivingEntity entity, DataComponentType<T> componentType) {
        MutableInt mutableInt = new MutableInt();
        EnchantmentHelper.runIterationOnEquipment((LivingEntity)entity, (holder, enchantmentLevel, enchantedItemInUse) -> {
            Object t;
            if (mutableInt.getValue() < enchantmentLevel && (t = ((Enchantment)holder.value()).effects().get(componentType)) != null) {
                mutableInt.setValue(enchantmentLevel);
            }
        });
        return mutableInt.getValue();
    }
}

