/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.DataComponentUtil;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.Map;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemFilter {
    private Item item = Items.AIR;
    private TagKey<Item> tag = null;
    private Tag componentsAsNbt = null;
    private PatchedDataComponentMap components;
    private int count = 64;
    private String fingerprint = "";
    public int fromSlot = -1;
    public int toSlot = -1;

    private ItemFilter() {
    }

    public static Pair<ItemFilter, String> parse(Map<?, ?> item) {
        ItemFilter itemFilter = ItemFilter.empty();
        if (item.isEmpty()) {
            return Pair.of(itemFilter, null);
        }
        if (item.containsKey("name")) {
            try {
                String name = TableHelper.getStringField(item, (String)"name");
                if (name.startsWith("#")) {
                    itemFilter.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)name.substring(1)));
                } else {
                    itemFilter.item = (Item)ItemUtil.getRegistryEntry(name, BuiltInRegistries.ITEM);
                    if (itemFilter.item == null) {
                        return Pair.of(null, "ITEM_NOT_FOUND");
                    }
                }
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_ITEM");
            }
        }
        if (item.containsKey("components")) {
            try {
                itemFilter.componentsAsNbt = NBTUtil.fromText(TableHelper.getStringField(item, (String)"components"));
            }
            catch (LuaException luaException) {
                try {
                    itemFilter.componentsAsNbt = NBTUtil.fromText(TableHelper.getTableField(item, (String)"components").toString());
                }
                catch (LuaException e) {
                    return Pair.of(null, "NO_VALID_COMPONENTS");
                }
            }
        }
        if (item.containsKey("fingerprint")) {
            try {
                itemFilter.fingerprint = TableHelper.getStringField(item, (String)"fingerprint");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FINGERPRINT");
            }
        }
        if (item.containsKey("fromSlot")) {
            try {
                itemFilter.fromSlot = TableHelper.getIntField(item, (String)"fromSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FROMSLOT");
            }
        }
        if (item.containsKey("toSlot")) {
            try {
                itemFilter.toSlot = TableHelper.getIntField(item, (String)"toSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_TOSLOT");
            }
        }
        if (item.containsKey("count")) {
            try {
                itemFilter.count = TableHelper.getIntField(item, (String)"count");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_COUNT");
            }
        }
        AdvancedPeripherals.debug("Parsed item filter: " + String.valueOf(itemFilter));
        return Pair.of(itemFilter, null);
    }

    public static ItemFilter fromStack(ItemStack stack) {
        ItemFilter filter = ItemFilter.empty();
        filter.item = stack.getItem();
        filter.componentsAsNbt = DataComponentUtil.toNbt(stack.getComponentsPatch());
        filter.components = (PatchedDataComponentMap)stack.getComponents();
        return filter;
    }

    public static ItemFilter empty() {
        return new ItemFilter();
    }

    public boolean isEmpty() {
        return this.fingerprint.isEmpty() && this.item == Items.AIR && this.tag == null && this.componentsAsNbt == null;
    }

    public ItemStack toItemStack() {
        ItemStack result = new ItemStack((ItemLike)this.item, this.count);
        if (this.components != null) {
            result.applyComponents((DataComponentMap)this.components);
        }
        return result;
    }

    public boolean test(ItemStack stack) {
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = ItemUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (this.item != Items.AIR && !stack.is(this.item)) {
            return false;
        }
        if (this.tag != null && !stack.is(this.tag)) {
            return false;
        }
        return this.componentsAsNbt == null || DataComponentUtil.toNbt(stack.getComponentsPatch()).equals((Object)this.componentsAsNbt);
    }

    public int getCount() {
        return this.count;
    }

    public Item getItem() {
        return this.item;
    }

    public int getFromSlot() {
        return this.fromSlot;
    }

    public int getToSlot() {
        return this.toSlot;
    }

    public Tag getComponentsAsNbt() {
        return this.componentsAsNbt;
    }

    public String toString() {
        return "ItemFilter{item=" + String.valueOf(ItemUtil.getRegistryKey(this.item)) + ", tag=" + String.valueOf(this.tag) + ", components=" + String.valueOf(this.componentsAsNbt) + ", count=" + this.count + ", fingerprint='" + this.fingerprint + "', fromSlot=" + this.fromSlot + ", toSlot=" + this.toSlot + "}";
    }
}

