/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemFluidHandler;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemItemHandler;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    private InventoryUtil() {
    }

    public static IItemHandler extractHandler(@Nullable Object object, @Nullable Level level, @Nullable BlockPos pos, @Nullable Direction direction) {
        if (object instanceof IItemHandler) {
            IItemHandler itemHandler = (IItemHandler)object;
            return itemHandler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        if (object instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)object;
            if (level == null && pos == null) {
                pos = blockEntity.getBlockPos();
                level = blockEntity.getLevel();
            }
        }
        if (level != null && pos != null) {
            return (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)(direction != null ? direction : Direction.NORTH));
        }
        return null;
    }

    public static int moveItem(IItemHandler inventoryFrom, IItemHandler inventoryTo, ItemFilter filter) {
        if (inventoryFrom == null) {
            return 0;
        }
        int fromSlot = filter.getFromSlot();
        int toSlot = filter.getToSlot();
        int amount = filter.getCount();
        int transferableAmount = 0;
        if (inventoryFrom instanceof IStorageSystemItemHandler) {
            IStorageSystemItemHandler storageSystemHandler = (IStorageSystemItemHandler)inventoryFrom;
            for (int i = toSlot == -1 ? 0 : toSlot; i < (toSlot == -1 ? inventoryTo.getSlots() : toSlot + 1); ++i) {
                ItemStack extracted = storageSystemHandler.extractItem(filter, filter.getCount(), true);
                if (extracted.isEmpty()) continue;
                ItemStack inserted = toSlot == -1 ? ItemHandlerHelper.insertItem((IItemHandler)inventoryTo, (ItemStack)extracted, (boolean)false) : inventoryTo.insertItem(toSlot, extracted, false);
                amount -= extracted.getCount() - inserted.getCount();
                if ((transferableAmount += storageSystemHandler.extractItem(filter, extracted.getCount() - inserted.getCount(), false).getCount()) >= filter.getCount()) break;
            }
            return transferableAmount;
        }
        if (inventoryTo instanceof IStorageSystemItemHandler) {
            IStorageSystemItemHandler storageSystemHandler = (IStorageSystemItemHandler)inventoryTo;
            for (int i = fromSlot == -1 ? 0 : fromSlot; i < (fromSlot == -1 ? inventoryFrom.getSlots() : fromSlot + 1); ++i) {
                ItemStack extracted;
                if (!filter.test(inventoryFrom.getStackInSlot(i)) || (extracted = inventoryFrom.extractItem(i, amount - transferableAmount, true)).isEmpty()) continue;
                ItemStack inserted = storageSystemHandler.insertItem(toSlot, extracted, false);
                amount -= inserted.getCount();
                if ((transferableAmount += inventoryFrom.extractItem(i, extracted.getCount() - inserted.getCount(), false).getCount()) >= filter.getCount()) break;
            }
            return transferableAmount;
        }
        for (int i = fromSlot == -1 ? 0 : fromSlot; i < (fromSlot == -1 ? inventoryFrom.getSlots() : fromSlot + 1); ++i) {
            ItemStack extracted;
            if (!filter.test(inventoryFrom.getStackInSlot(i)) || (extracted = inventoryFrom.extractItem(i, amount - transferableAmount, true)).isEmpty()) continue;
            ItemStack inserted = toSlot == -1 ? ItemHandlerHelper.insertItem((IItemHandler)inventoryTo, (ItemStack)extracted, (boolean)false) : inventoryTo.insertItem(toSlot, extracted, false);
            amount -= inserted.getCount();
            if ((transferableAmount += inventoryFrom.extractItem(i, extracted.getCount() - inserted.getCount(), false).getCount()) >= filter.getCount()) break;
        }
        return transferableAmount;
    }

    public static int moveFluid(IFluidHandler inventoryFrom, IFluidHandler inventoryTo, FluidFilter filter) {
        if (inventoryFrom == null) {
            return 0;
        }
        int amount = filter.getCount();
        int transferableAmount = 0;
        if (inventoryFrom instanceof IStorageSystemFluidHandler) {
            IStorageSystemFluidHandler storageSystemHandler = (IStorageSystemFluidHandler)inventoryFrom;
            FluidStack extracted = storageSystemHandler.drain(filter, IFluidHandler.FluidAction.SIMULATE);
            int inserted = inventoryTo.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
            return transferableAmount += storageSystemHandler.drain(filter.setCount(inserted), IFluidHandler.FluidAction.EXECUTE).getAmount();
        }
        if (inventoryTo instanceof IStorageSystemFluidHandler) {
            IStorageSystemFluidHandler storageSystemHandler = (IStorageSystemFluidHandler)inventoryTo;
            if (filter.test(inventoryFrom.getFluidInTank(0))) {
                FluidStack toExtract = inventoryFrom.getFluidInTank(0).copy();
                toExtract.setAmount(amount);
                FluidStack extracted = inventoryFrom.drain(toExtract, IFluidHandler.FluidAction.SIMULATE);
                if (extracted.isEmpty()) {
                    return 0;
                }
                int inserted = storageSystemHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                extracted.setAmount(inserted);
                transferableAmount += inventoryFrom.drain(extracted, IFluidHandler.FluidAction.EXECUTE).getAmount();
            }
            return transferableAmount;
        }
        return transferableAmount;
    }

    @Nullable
    public static IItemHandler getHandlerFromName(@NotNull IComputerAccess access, String name) throws LuaException {
        IPeripheral location = access.getAvailablePeripheral(name);
        if (location == null) {
            return null;
        }
        return InventoryUtil.extractHandler(location.getTarget(), null, null, null);
    }

    @Nullable
    public static IItemHandler getHandlerFromDirection(@NotNull String direction, @NotNull IPeripheralOwner owner) throws LuaException {
        Level level = owner.getLevel();
        Objects.requireNonNull(level);
        Direction relativeDirection = CoordUtil.getDirection(owner.getOrientation(), direction);
        BlockEntity target = level.getBlockEntity(owner.getPos().relative(relativeDirection));
        if (target == null) {
            return null;
        }
        return InventoryUtil.extractHandler(target, level, target.getBlockPos(), relativeDirection.getOpposite());
    }
}

