/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.DataComponentUtil;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.Map;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidFilter {
    private Fluid fluid = Fluids.EMPTY;
    private TagKey<Fluid> tag = null;
    private Tag componentsAsNbt = null;
    private PatchedDataComponentMap components;
    private int count = 1000;
    private String fingerprint = "";

    private FluidFilter() {
    }

    public static Pair<FluidFilter, String> parse(Map<?, ?> item) {
        FluidFilter fluidFilter = FluidFilter.empty();
        if (item.isEmpty()) {
            return Pair.of(fluidFilter, null);
        }
        if (item.containsKey("name")) {
            try {
                String name = TableHelper.getStringField(item, (String)"name");
                if (name.startsWith("#")) {
                    fluidFilter.tag = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)name.substring(1)));
                } else {
                    fluidFilter.fluid = (Fluid)ItemUtil.getRegistryEntry(name, BuiltInRegistries.FLUID);
                    if (fluidFilter.fluid == null) {
                        return Pair.of(null, "FLUID_NOT_FOUND");
                    }
                }
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FLUID");
            }
        }
        if (item.containsKey("components")) {
            try {
                fluidFilter.componentsAsNbt = NBTUtil.fromText(TableHelper.getStringField(item, (String)"components"));
            }
            catch (LuaException luaException) {
                try {
                    fluidFilter.componentsAsNbt = NBTUtil.fromText(TableHelper.getTableField(item, (String)"components").toString());
                }
                catch (LuaException e) {
                    return Pair.of(null, "NO_VALID_COMPONENTS");
                }
            }
        }
        if (item.containsKey("fingerprint")) {
            try {
                fluidFilter.fingerprint = TableHelper.getStringField(item, (String)"fingerprint");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FINGERPRINT");
            }
        }
        if (item.containsKey("count")) {
            try {
                fluidFilter.count = TableHelper.getIntField(item, (String)"count");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_COUNT");
            }
        }
        AdvancedPeripherals.debug("Parsed fluid filter: " + String.valueOf(fluidFilter));
        return Pair.of(fluidFilter, null);
    }

    public static FluidFilter fromStack(FluidStack stack) {
        FluidFilter filter = FluidFilter.empty();
        filter.fluid = stack.getFluid();
        filter.componentsAsNbt = DataComponentUtil.toNbt(stack.getComponentsPatch());
        filter.components = stack.getComponents();
        return filter;
    }

    public static FluidFilter empty() {
        return new FluidFilter();
    }

    public boolean isEmpty() {
        return this.fingerprint.isEmpty() && this.fluid == Fluids.EMPTY && this.tag == null && this.componentsAsNbt == null;
    }

    public FluidStack toFluidStack() {
        FluidStack result = new FluidStack(this.fluid, this.count);
        if (this.componentsAsNbt != null) {
            result.applyComponents((DataComponentMap)this.components);
        }
        return result;
    }

    public FluidFilter setCount(int count) {
        this.count = count;
        return this;
    }

    public boolean test(FluidStack stack) {
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = FluidUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (this.fluid != Fluids.EMPTY && !stack.getFluid().isSame(this.fluid)) {
            return false;
        }
        if (this.tag != null && !stack.getFluid().is(this.tag)) {
            return false;
        }
        return this.componentsAsNbt == null || DataComponentUtil.toNbt(stack.getComponentsPatch()).equals((Object)this.componentsAsNbt);
    }

    public int getCount() {
        return this.count;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Tag getComponentsAsNbt() {
        return this.componentsAsNbt;
    }

    public String toString() {
        return "FluidFilter{fluid=" + String.valueOf(FluidUtil.getRegistryKey(this.fluid)) + ", tag=" + String.valueOf(this.tag) + ", components=" + String.valueOf(this.componentsAsNbt) + ", count=" + this.count + ", fingerprint='" + this.fingerprint + "'}";
    }
}

