/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.data;

import de.srendi.advancedperipherals.common.blocks.base.BaseBlock;
import de.srendi.advancedperipherals.common.setup.Blocks;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStatesAndModelsProvider
extends BlockStateProvider {
    public BlockStatesAndModelsProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "advancedperipherals", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.peripheralBlock((Block)Blocks.ENVIRONMENT_DETECTOR.get(), "front", "top");
        this.peripheralBlock((Block)Blocks.CHAT_BOX.get(), "front", "top");
        this.peripheralBlock((Block)Blocks.ME_BRIDGE.get(), "front", "top");
        this.peripheralBlock((Block)Blocks.ENERGY_DETECTOR.get(), "front", "back", "top", "east");
        this.peripheralBlock((Block)Blocks.INVENTORY_MANAGER.get(), "front", "top");
        this.peripheralBlock((Block)Blocks.GEO_SCANNER.get(), "front", "top");
        this.peripheralBlock((Block)Blocks.COLONY_INTEGRATOR.get(), "front", "top");
        this.peripheralBlock((Block)Blocks.NBT_STORAGE.get(), "front", "top");
        this.peripheralBlock((Block)Blocks.PLAYER_DETECTOR.get(), (ModelFile)this.generateModel((Block)Blocks.PLAYER_DETECTOR.get(), false, "side", "front", "top"));
        this.peripheralBlock((Block)Blocks.REDSTONE_INTEGRATOR.get(), (ModelFile)this.generateModel((Block)Blocks.REDSTONE_INTEGRATOR.get(), false, "side", "front", "top", "bottom"));
        this.peripheralBlock((Block)Blocks.BLOCK_READER.get(), (ModelFile)this.generateModel((Block)Blocks.BLOCK_READER.get(), false, "north", "south", "east", "west", "up", "down"));
        this.peripheralBlock((Block)Blocks.PERIPHERAL_CASING.get(), new String[0]);
    }

    private void peripheralBlock(Block block, ModelFile file) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int y;
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile(file);
            FrontAndTop orientation = (FrontAndTop)state.getValue(BaseBlock.ORIENTATION);
            int x = 0;
            if (orientation.top().getAxis() == Direction.Axis.Y) {
                y = (int)(orientation.front().toYRot() + 180.0f) % 360;
            } else {
                x = orientation.front() == Direction.DOWN ? 90 : 270;
                y = (int)(orientation.top().toYRot() + 180.0f) % 360;
            }
            builder.rotationX(x);
            builder.rotationY(y);
            return builder.build();
        });
    }

    private void peripheralBlock(Block block, String ... sides) {
        this.peripheralBlock(block, (ModelFile)this.generateModel(block, true, sides));
    }

    private BlockModelBuilder generateModel(Block block, boolean hasNormalSide, String ... sides) {
        ResourceLocation particleTexture = this.blockTexture(block);
        BlockModelBuilder builder = hasNormalSide ? this.generateModel(block) : (BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/cube_all"));
        for (String sideTexture : sides) {
            String side = sideTexture;
            if (side.equals("side")) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    builder.texture(direction.toString(), this.blockTexture(block, sideTexture));
                }
            }
            if (side.equals("north")) {
                particleTexture = this.blockTexture(block, "north");
            }
            if (side.equals("front")) {
                side = "north";
                particleTexture = this.blockTexture(block, "front");
            }
            if (side.equals("top")) {
                side = "up";
            }
            if (side.equals("bottom")) {
                side = "down";
            }
            if (side.equals("back")) {
                side = "south";
            }
            builder.texture(side, this.blockTexture(block, sideTexture));
        }
        builder.texture("particle", particleTexture);
        return builder;
    }

    private BlockModelBuilder generateModel(Block block) {
        return (BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block));
    }

    private ResourceLocation blockTexture(Block block, String offset) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + "_" + offset));
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }
}

