/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.configuration;

import de.srendi.advancedperipherals.common.addons.computercraft.operations.SimpleFreeOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.configuration.IAPConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.FieldsAreNonnullByDefault;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

@FieldsAreNonnullByDefault
public class PeripheralsConfig
implements IAPConfig {
    public final ModConfigSpec.IntValue playerDetMaxRange;
    public final ModConfigSpec.BooleanValue playerSpy;
    public final ModConfigSpec.BooleanValue morePlayerInformation;
    public final ModConfigSpec.BooleanValue enablePlayerDetector;
    public final ModConfigSpec.BooleanValue playerDetMultiDimensional;
    public final ModConfigSpec.BooleanValue playerSpyRandError;
    public final ModConfigSpec.IntValue playerSpyRandErrorAmount;
    public final ModConfigSpec.IntValue playerSpyPreciseMaxRange;
    public final ModConfigSpec.IntValue energyDetectorMaxFlow;
    public final ModConfigSpec.BooleanValue enableEnergyDetector;
    public final ModConfigSpec.IntValue nbtStorageMaxSize;
    public final ModConfigSpec.BooleanValue enableNBTStorage;
    public final ModConfigSpec.IntValue chunkLoadValidTime;
    public final ModConfigSpec.IntValue chunkyTurtleRadius;
    public final ModConfigSpec.BooleanValue enableChunkyTurtle;
    public final ModConfigSpec.BooleanValue enableChatBox;
    public final ModConfigSpec.ConfigValue<String> defaultChatBoxPrefix;
    public final ModConfigSpec.IntValue chatBoxMaxRange;
    public final ModConfigSpec.BooleanValue chatBoxMultiDimensional;
    public final ModConfigSpec.BooleanValue chatBoxPreventRunCommand;
    public final ModConfigSpec.BooleanValue chatBoxWrapCommand;
    public final ModConfigSpec.ConfigValue<List<? extends String>> chatBoxBannedCommands;
    private List<Predicate<String>> chatBoxCommandFilters = null;
    public final ModConfigSpec.BooleanValue enableMEBridge;
    public final ModConfigSpec.IntValue meConsumption;
    public final ModConfigSpec.BooleanValue enableRSBridge;
    public final ModConfigSpec.IntValue rsConsumption;
    public final ModConfigSpec.BooleanValue enableEnvironmentDetector;
    public final ModConfigSpec.BooleanValue enableARGoggles;
    public final ModConfigSpec.BooleanValue enableInventoryManager;
    public final ModConfigSpec.BooleanValue enableRedstoneIntegrator;
    public final ModConfigSpec.BooleanValue enableBlockReader;
    public final ModConfigSpec.BooleanValue enableGeoScanner;
    public final ModConfigSpec.BooleanValue enableColonyIntegrator;
    public final ModConfigSpec.BooleanValue enableCompassTurtle;
    public final ModConfigSpec.IntValue compassAccurePlaceRadius;
    public final ModConfigSpec.IntValue compassAccurePlaceFreeRadius;
    public final ModConfigSpec.BooleanValue enablePoweredPeripherals;
    public final ModConfigSpec.BooleanValue disablePocketFuelConsumption;
    public final ModConfigSpec.IntValue poweredPeripheralMaxEnergyStorage;
    private final ModConfigSpec configSpec;
    private static final List<String> chatBoxDefaultBannedCommands = Arrays.asList("/execute", "/op", "/deop", "/gamemode", "/gamerule", "/stop", "/give", "/fill", "/setblock", "/summon", "/whitelist", "^/ban-(?:ip)?\\s*", "^/pardon-(?:ip)?\\s*", "^/save-(?:on|off)\\s*");

    public PeripheralsConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Peripherals config").push("Peripherals");
        builder.push("Player_Detector");
        this.enablePlayerDetector = builder.comment("Enable the Player Detector or not.").define("enablePlayerDetector", true);
        this.playerDetMaxRange = builder.comment("The max range of the player detector functions. If anyone use a higher range, the detector will use this max range. -1 for unlimited").defineInRange("playerDetMaxRange", -1, -1, Integer.MAX_VALUE);
        this.playerSpy = builder.comment("Activates the \"getPlayerPos\" function of the Player Detector").define("enablePlayerPosFunction", true);
        this.morePlayerInformation = builder.comment("Adds more information to `getPlayerPos` of the Player Detector. Like rotation and dimension").define("morePlayerInformation", true);
        this.playerDetMultiDimensional = builder.comment("If true, the player detector can observe players which aren't in the same dimension as the detector itself. `playerDetMaxRange` needs to be infinite(-1) for it to work.").define("chatBoxMultiDimensional", true);
        this.playerSpyRandError = builder.comment("If true, add random error to `getPlayerPos` player position that varies based on how far the player is from the detector. Prevents getting the exact position of players far from the detector.").define("enablePlayerPosRandomError", false);
        this.playerSpyRandErrorAmount = builder.comment("The maximum amount of error (in blocks) that can be applied to each axis of the player's position.").defineInRange("playerPosRandomErrorAmount", 1000, 0, Integer.MAX_VALUE);
        this.playerSpyPreciseMaxRange = builder.comment("If random error is enabled: this is the maximum range at which an exact player position is returned, before random error starts to be applied.").defineInRange("playerPosPreciseMaxRange", 100, 0, Integer.MAX_VALUE);
        this.pop("Energy_Detector", builder);
        this.enableEnergyDetector = builder.comment("Enable the Energy Detector or not.").define("enableEnergyDetector", true);
        this.energyDetectorMaxFlow = builder.comment("Defines the maximum energy flow of the energy detector.").defineInRange("energyDetectorMaxFlow", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.pop("NBT_Storage", builder);
        this.enableNBTStorage = builder.comment("Enable the nbt storage block or not").define("enableNBTStorage", true);
        this.nbtStorageMaxSize = builder.comment("Defines max nbt string length that can be stored in nbt storage").defineInRange("nbtStorageMaxSize", 0x100000, 0, Integer.MAX_VALUE);
        this.pop("Chunky_Turtle", builder);
        this.enableChunkyTurtle = builder.comment("Enable the Chunky Turtle or not.").define("enableChunkyTurtle", true);
        this.chunkLoadValidTime = builder.comment("Time in seconds, while loaded chunk can be consider as valid without touch").defineInRange("chunkLoadValidTime", 600, 60, Integer.MAX_VALUE);
        this.chunkyTurtleRadius = builder.comment("Radius in chunks a single chunky turtle will load. The default value (0) only loads the chunk the turtle is in, 1 would also load the 8 surrounding chunks (9 in total) and so on").defineInRange("chunkyTurtleRadius", 0, 0, 16);
        this.pop("Chat_Box", builder);
        this.enableChatBox = builder.comment("Enable the Chat Box or not.").define("enableChatBox", true);
        this.defaultChatBoxPrefix = builder.comment("Defines default chatbox prefix").define("defaultChatBoxPrefix", (Object)"AP");
        this.chatBoxMaxRange = builder.comment("Defines the maximal range of the chat box in blocks. -1 for infinite. If the range is not -1, players in other dimensions won't able to receive messages").defineInRange("chatBoxMaxRange", -1, -1, 30000000);
        this.chatBoxMultiDimensional = builder.comment("If true, the chat box is able to send messages to other dimensions than its own").define("chatBoxMultiDimensional", true);
        this.chatBoxPreventRunCommand = builder.comment("If true, the chat box cannot use 'run_command' action").define("chatBoxPreventRunCommand", false);
        this.chatBoxWrapCommand = builder.comment("If true, the chat box will wrap and execute 'run_command' or 'suggest_command' action with zero permission, in order to prevent operators accidently run dangerous commands.").define("chatBoxWrapCommand", true);
        this.chatBoxBannedCommands = builder.comment("These commands below will not be able to send by 'run_command' or 'suggest_command' action. It will match as prefix if starts with '/', other wise use regex pattern").defineList("chatBoxBannedCommands", chatBoxDefaultBannedCommands, o -> {
            String value;
            return o instanceof String && (value = (String)o).length() > 0;
        });
        this.pop("ME_Bridge", builder);
        this.enableMEBridge = builder.comment("Enable the Me Bridge or not.").define("enableMeBridge", true);
        this.meConsumption = builder.comment("Power consumption per tick.").defineInRange("mePowerConsumption", 10, 0, Integer.MAX_VALUE);
        this.pop("RS_Bridge", builder);
        this.enableRSBridge = builder.comment("Enable the Rs Bridge or not.").define("enableRsBridge", true);
        this.rsConsumption = builder.comment("Power consumption per tick.").defineInRange("rsPowerConsumption", 10, 0, Integer.MAX_VALUE);
        this.pop("Environment_Detector", builder);
        this.enableEnvironmentDetector = builder.comment("Enable the Environment Detector or not.").define("enableEnvironmentDetector", true);
        this.pop("AR_Controller", builder);
        this.enableARGoggles = builder.comment("Enable the AR goggles or not.").define("enableARGoggles", true);
        this.pop("Inventory_Manager", builder);
        this.enableInventoryManager = builder.comment("Enable the inventory manager or not.").define("enableInventoryManager", true);
        this.pop("Redstone_Integrator", builder);
        this.enableRedstoneIntegrator = builder.comment("Enable the redstone integrator or not.").define("enableRedstoneIntegrator", true);
        this.pop("Block_Reader", builder);
        this.enableBlockReader = builder.comment("Enable the block reader or not.").define("enableBlockReader", true);
        this.pop("Geo_Scanner", builder);
        this.enableGeoScanner = builder.comment("Enable the geo scanner or not.").define("enableGeoScanner", true);
        this.pop("Colony_Integrator", builder);
        this.enableColonyIntegrator = builder.comment("Enable the colony integrator or not.").define("enableColonyIntegrator", true);
        this.pop("Compass_Turtle", builder);
        this.enableCompassTurtle = builder.comment("Enable the compass turtle or not.").define("enableCompassTurtle", true);
        this.compassAccurePlaceRadius = builder.comment("The maximum distance the compass can locate accurately with in each axis.").defineInRange("compassAccurePlaceRadius", 3, 0, 8);
        this.compassAccurePlaceFreeRadius = builder.comment("The free distance the compass can locate accurately with in each axis.").defineInRange("compassAccurePlaceFreeRadius", 1, 0, 4);
        this.pop("Powered_Peripherals", builder);
        this.enablePoweredPeripherals = builder.comment("Enable RF storage for peripherals, that could use it").define("enablePoweredPeripherals", false);
        this.poweredPeripheralMaxEnergyStorage = builder.comment("Defines max energy storage in any powered peripheral").defineInRange("poweredPeripheralMaxEnergyStored", 100000000, 1000000, Integer.MAX_VALUE);
        this.pop("Pocket_Peripherals", builder);
        this.disablePocketFuelConsumption = builder.comment("If true, pockets will have infinite fuel").define("disablePocketFuelConsumption", true);
        this.pop("Operations", builder);
        this.register(SingleOperation.values(), builder);
        this.register(SphereOperation.values(), builder);
        this.register(SimpleFreeOperation.values(), builder);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public String getFileName() {
        return "peripherals";
    }

    @Override
    public ModConfig.Type getType() {
        return ModConfig.Type.COMMON;
    }

    private List<Predicate<String>> parseChatBoxCommandFilters() {
        ArrayList<Predicate<String>> filters = new ArrayList<Predicate<String>>();
        for (String s : (List)this.chatBoxBannedCommands.get()) {
            Object p = s;
            if (((String)p).charAt(0) == '/') {
                if (((String)(p = ((String)p).replaceAll("\\s+", "\\\\s+"))).equals(s)) {
                    String prefix = s;
                    filters.add(v -> v.startsWith(prefix) && (v.length() == prefix.length() || " \t".indexOf(v.charAt(prefix.length())) != -1));
                    continue;
                }
                p = "^" + (String)p + "\\s*";
            }
            filters.add(Pattern.compile((String)p).asPredicate());
        }
        return filters;
    }

    public List<Predicate<String>> getChatBoxCommandFilters() {
        if (this.chatBoxCommandFilters == null) {
            this.chatBoxCommandFilters = this.parseChatBoxCommandFilters();
        }
        return this.chatBoxCommandFilters;
    }
}

