/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import dan200.computercraft.shared.util.RedstoneUtil;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.RedstoneIntegratorPeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class RedstoneIntegratorEntity
extends PeripheralBlockEntity<RedstoneIntegratorPeripheral> {
    public int[] power = new int[Direction.values().length];

    public RedstoneIntegratorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.REDSTONE_INTEGRATOR.get(), pos, state);
    }

    @Override
    @NotNull
    protected RedstoneIntegratorPeripheral createPeripheral() {
        return new RedstoneIntegratorPeripheral(this);
    }

    public int getRedstoneInput(Direction direction) {
        Objects.requireNonNull(this.level);
        BlockPos neighbourPos = this.getBlockPos().relative(direction);
        int power = this.level.getSignal(neighbourPos, direction);
        if (power >= 15) {
            return power;
        }
        BlockState neighbourState = this.level.getBlockState(neighbourPos);
        return neighbourState.getBlock() == Blocks.REDSTONE_WIRE ? Math.max(power, (Integer)neighbourState.getValue((Property)RedStoneWireBlock.POWER)) : power;
    }

    private void setRedstoneOutput(Direction direction, int power) {
        int old = this.power[direction.get3DDataValue()];
        this.power[direction.get3DDataValue()] = power;
        if (old != power) {
            if (this.level != null) {
                RedstoneUtil.propagateRedstoneOutput((Level)this.level, (BlockPos)this.getBlockPos(), (Direction)direction);
            }
            this.setChanged();
        }
    }

    public void setOutput(Direction direction, int power) {
        ServerWorker.add(() -> this.setRedstoneOutput(direction, power));
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        for (Direction direction : Direction.values()) {
            this.setRedstoneOutput(direction, compound.getInt(direction.name() + "Power"));
        }
        super.loadAdditional(compound, provider);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        int i = 0;
        for (Direction direction : Direction.values()) {
            compound.putInt(direction.name() + "Power", this.power[i]);
            ++i;
        }
    }
}

