/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class AutomataItemSuckPlugin
extends AutomataCorePlugin {
    public AutomataItemSuckPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @Override
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.SUCK};
    }

    protected AABB getBox(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int interactionRadius = this.automataCore.getInteractionRadius();
        return new AABB((double)(x - interactionRadius), (double)(y - interactionRadius), (double)(z - interactionRadius), (double)(x + interactionRadius), (double)(y + interactionRadius), (double)(z + interactionRadius));
    }

    protected List<ItemEntity> getItems() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        return owner.getLevel().getEntitiesOfClass(ItemEntity.class, this.getBox(owner.getPos()));
    }

    protected int suckItem(ItemEntity entity, int requiredQuantity) {
        ItemStack leaveStack;
        ItemStack storeStack;
        ItemStack stack = entity.getItem().copy();
        if (stack.getCount() > requiredQuantity) {
            storeStack = stack.split(requiredQuantity);
            leaveStack = stack;
        } else {
            storeStack = stack;
            leaveStack = ItemStack.EMPTY;
        }
        ItemStack remainder = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).storeItem(storeStack);
        if (remainder != storeStack) {
            if (remainder.isEmpty() && leaveStack.isEmpty()) {
                entity.remove(Entity.RemovalReason.KILLED);
            } else if (remainder.isEmpty()) {
                entity.setItem(leaveStack);
            } else if (leaveStack.isEmpty()) {
                entity.setItem(remainder);
            } else {
                leaveStack.grow(remainder.getCount());
                entity.setItem(leaveStack);
            }
        }
        return requiredQuantity -= storeStack.getCount();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scanItems() {
        this.automataCore.addRotationCycle();
        List<ItemEntity> items = this.getItems();
        HashMap<Integer, Map<String, Object>> data = new HashMap<Integer, Map<String, Object>>();
        int index = 1;
        for (ItemEntity item : items) {
            ItemStack stack = item.getItem();
            Map<String, Object> itemData = LuaConverter.itemStackToObject(stack);
            itemData.put("entityID", item.getId());
            data.put(index, itemData);
            ++index;
        }
        return MethodResult.of(data);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult collectSpecificItem(@NotNull IArguments arguments) throws LuaException {
        String technicalName = arguments.getString(0);
        int requiredQuantityArg = arguments.optInt(1, Integer.MAX_VALUE);
        return this.automataCore.withOperation(SingleOperation.SUCK, context -> {
            List<ItemEntity> items = this.getItems();
            int requiredQuantity = requiredQuantityArg;
            for (ItemEntity item : items) {
                ResourceLocation itemName = BuiltInRegistries.ITEM.getKey((Object)item.getItem().getItem());
                if (itemName == null) continue;
                if (itemName.toString().equals(technicalName)) {
                    requiredQuantity -= this.suckItem(item, requiredQuantity);
                }
                if (requiredQuantity > 0) continue;
                break;
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult collectItems(@NotNull IArguments arguments) throws LuaException {
        int requiredQuantityArg = arguments.optInt(0, Integer.MAX_VALUE);
        return this.automataCore.withOperation(SingleOperation.SUCK, context -> {
            if (requiredQuantityArg == 0) {
                return MethodResult.of((Object)true);
            }
            List<ItemEntity> items = this.getItems();
            if (items.isEmpty()) {
                return MethodResult.of((Object[])new Object[]{null, "Nothing to take"});
            }
            int requiredQuantity = requiredQuantityArg;
            for (ItemEntity entity : items) {
                if ((requiredQuantity -= this.suckItem(entity, requiredQuantity)) <= 0) break;
            }
            return MethodResult.of((Object)true);
        });
    }
}

