/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.InventoryManagerEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.InventoryUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public class InventoryManagerPeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<InventoryManagerEntity>> {
    public static final String PERIPHERAL_TYPE = "inventoryManager";

    public InventoryManagerPeripheral(InventoryManagerEntity tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<InventoryManagerEntity>(tileEntity));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableInventoryManager.get();
    }

    @LuaFunction
    public final String getOwner() throws LuaException {
        if (((BlockEntityPeripheralOwner)this.owner).getOwner() == null) {
            return null;
        }
        return this.getOwnerPlayer().getName().getString();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult addItemToPlayer(String invDirection, Map<?, ?> item) throws LuaException {
        Pair<ItemFilter, String> filter = ItemFilter.parse(item);
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return this.addItemCommon(invDirection, filter.getLeft());
    }

    private MethodResult addItemCommon(String invDirection, ItemFilter filter) throws LuaException {
        Direction direction = this.validateSide(invDirection);
        Pair<IItemHandler, Integer> inventoryTo = this.getHandlerFromSlot(filter.getToSlot());
        IItemHandler inventoryFrom = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, ((BlockEntityPeripheralOwner)this.owner).getPos().relative(direction), (Object)direction.getOpposite());
        if (inventoryFrom == null) {
            return MethodResult.of((Object[])new Object[]{0, "INVENTORY_FROM_INVALID"});
        }
        inventoryTo.ifRightPresent(slot -> {
            filter.toSlot = slot;
        });
        return MethodResult.of((Object)InventoryUtil.moveItem(inventoryFrom, inventoryTo.getLeft(), filter));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult removeItemFromPlayer(String invDirection, Map<?, ?> item) throws LuaException {
        Pair<ItemFilter, String> filter = ItemFilter.parse(item);
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return this.removeItemCommon(invDirection, filter.getLeft());
    }

    private MethodResult removeItemCommon(String invDirection, ItemFilter filter) throws LuaException {
        Direction direction = this.validateSide(invDirection);
        Pair<IItemHandler, Integer> inventoryFrom = this.getHandlerFromSlot(filter.getFromSlot());
        IItemHandler inventoryTo = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, ((BlockEntityPeripheralOwner)this.owner).getPos().relative(direction), (Object)direction.getOpposite());
        if (inventoryTo == null) {
            return MethodResult.of((Object[])new Object[]{0, "INVENTORY_TO_INVALID"});
        }
        inventoryFrom.ifRightPresent(slot -> {
            filter.fromSlot = slot;
        });
        return MethodResult.of((Object)InventoryUtil.moveItem(inventoryFrom.getLeft(), inventoryTo, filter));
    }

    @LuaFunction(value={"list", "getItems"}, mainThread=true)
    public final List<Object> getItems() throws LuaException {
        ArrayList<Object> items = new ArrayList<Object>();
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().getInventory().items) {
            ItemStack copiedStack = stack.copy();
            if (!copiedStack.isEmpty()) {
                items.add(LuaConverter.stackToObjectWithSlot(copiedStack, i));
            }
            ++i;
        }
        return items;
    }

    @LuaFunction(value={"listChest", "getItemsChest"}, mainThread=true)
    public final MethodResult getItemsChest(String target) throws LuaException {
        Direction direction = this.validateSide(target);
        BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().getBlockEntity(((BlockEntityPeripheralOwner)this.owner).getPos().relative(direction));
        Object inventoryTo = null;
        if (inventoryTo == null) {
            return MethodResult.of((Object[])new Object[]{null, "INVENTORY_TO_INVALID"});
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (int slot = 0; slot < inventoryTo.getSlots(); ++slot) {
            if (inventoryTo.getStackInSlot(slot).isEmpty()) continue;
            items.add(LuaConverter.stackToObjectWithSlot(inventoryTo.getStackInSlot(slot).copy(), slot));
        }
        return MethodResult.of(items);
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getArmor() throws LuaException {
        ArrayList<Object> items = new ArrayList<Object>();
        for (ItemStack stack : this.getOwnerPlayer().getInventory().armor) {
            ItemStack copiedStack = stack.copy();
            if (copiedStack.isEmpty()) continue;
            items.add(LuaConverter.stackToObjectWithSlot(copiedStack, ArmorSlot.getSlotForItem(copiedStack)));
        }
        return items;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerEquipped() throws LuaException {
        for (ItemStack stack : this.getOwnerPlayer().getInventory().armor) {
            if (stack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isWearing(int index) throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().getInventory().armor) {
            if (stack.isEmpty()) continue;
            if (index == i - 100) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final int getEmptySpace() throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().getInventory().items) {
            if (!stack.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSpaceAvailable() throws LuaException {
        return this.getEmptySpace() > 0;
    }

    @LuaFunction(mainThread=true)
    public final int getFreeSlot() throws LuaException {
        return this.getOwnerPlayer().getInventory().getFreeSlot();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getItemInHand() throws LuaException {
        return LuaConverter.itemStackToObject(this.getOwnerPlayer().getMainHandItem().copy());
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getItemInOffHand() throws LuaException {
        return LuaConverter.itemStackToObject(this.getOwnerPlayer().getOffhandItem().copy());
    }

    private Player getOwnerPlayer() throws LuaException {
        if (((BlockEntityPeripheralOwner)this.owner).getOwner() == null) {
            throw new LuaException("The Inventory Manager doesn't have a memory card or it isn't bound to a player.");
        }
        return ((BlockEntityPeripheralOwner)this.owner).getOwner();
    }

    @NotNull
    private Pair<IItemHandler, Integer> getHandlerFromSlot(int slot) throws LuaException {
        PlayerArmorInvWrapper handler;
        if (slot >= 100 && slot <= 103) {
            handler = new PlayerArmorInvWrapper(this.getOwnerPlayer().getInventory());
            slot -= 100;
        } else if (slot == 36) {
            handler = new PlayerOffhandInvWrapper(this.getOwnerPlayer().getInventory());
            slot = 0;
        } else {
            handler = new PlayerInvWrapper(this.getOwnerPlayer().getInventory());
        }
        return Pair.of(handler, slot);
    }

    private static enum ArmorSlot {
        HELMET_SLOT(103, EquipmentSlot.HEAD),
        CHEST_SLOT(102, EquipmentSlot.CHEST),
        LEGGINGS_SLOT(101, EquipmentSlot.LEGS),
        BOOTS_SLOT(100, EquipmentSlot.FEET);

        private final int slot;
        private final EquipmentSlot slotType;

        private ArmorSlot(int slot, EquipmentSlot slotType) {
            this.slot = slot;
            this.slotType = slotType;
        }

        public static int getSlotForItem(ItemStack stack) {
            ArmorSlot[] armorSlotArray = stack.getItem();
            if (armorSlotArray instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)armorSlotArray;
                for (ArmorSlot slot : ArmorSlot.values()) {
                    if (armorItem.getEquipmentSlot() != slot.slotType) continue;
                    return slot.slot;
                }
            }
            AdvancedPeripherals.debug("Tried to get armor item slot for non armor item " + String.valueOf(stack) + ". Returning 0", Level.WARN);
            return 0;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

