/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemItemHandler;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MeItemHandler
implements IStorageSystemItemHandler {
    @NotNull
    private final MEStorage storageMonitor;
    @NotNull
    private final IActionSource actionSource;

    public MeItemHandler(@NotNull MEStorage storageMonitor, @NotNull IActionSource actionSource) {
        this.storageMonitor = storageMonitor;
        this.actionSource = actionSource;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        AEItemKey itemKey = AEItemKey.of((ItemStack)stack);
        long inserted = this.storageMonitor.insert((AEKey)itemKey, (long)stack.getCount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        ItemStack insertedStack = stack.copy();
        insertedStack.setCount(insertedStack.getCount() - (int)inserted);
        return insertedStack;
    }

    @Override
    public ItemStack extractItem(ItemFilter filter, int count, boolean simulate) {
        Pair<Long, AEItemKey> itemKey = AppEngApi.findAEStackFromFilter(this.storageMonitor, null, filter);
        if (itemKey.getRight() == null) {
            return ItemStack.EMPTY;
        }
        long extracted = this.storageMonitor.extract((AEKey)itemKey.getRight(), (long)count, simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        ItemStack stack = itemKey.getRight().toStack();
        stack.setCount((int)extracted);
        return stack;
    }
}

