/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.xmod.rei.recipes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.advanced_ae.xmod.rei.REIPlugin;

public class REIReactionChamberDisplay
implements Display {
    public static final CategoryIdentifier<REIReactionChamberDisplay> ID = CategoryIdentifier.of((ResourceLocation)AdvancedAE.makeId("rei_reaction_chamber"));
    private final RecipeHolder<ReactionChamberRecipe> holder;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final List<EntryIngredient> combined;
    private final EntryIngredient fluid;
    private final int energy;

    public REIReactionChamberDisplay(RecipeHolder<ReactionChamberRecipe> holder) {
        this.holder = holder;
        ReactionChamberRecipe recipe = (ReactionChamberRecipe)holder.value();
        this.inputs = recipe.getInputs().stream().map(REIPlugin::stackOf).filter(o -> !o.isEmpty()).toList();
        this.fluid = recipe.getFluid() != null ? REIPlugin.stackOf(recipe.getFluid(), 16000.0f) : EntryIngredient.empty();
        EntryStack fluid = EntryStacks.of((Fluid)recipe.getResultFluid().getFluid(), (long)recipe.getResultFluid().getAmount());
        ClientEntryStacks.setFluidRenderRatio((EntryStack)fluid, (float)((float)recipe.getResultFluid().getAmount() / 16000.0f));
        this.outputs = ImmutableList.of((Object)EntryIngredients.of((ItemStack)recipe.getResultItem()), (Object)EntryIngredient.builder().add(fluid).build());
        this.combined = new ArrayList<EntryIngredient>(this.inputs);
        if (!this.fluid.isEmpty()) {
            this.combined.addLast(this.fluid);
        }
        this.energy = recipe.getEnergy();
    }

    public List<EntryIngredient> getInputItems() {
        return this.inputs;
    }

    public EntryIngredient getInputFluid() {
        return this.fluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.combined;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ID;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.holder.id());
    }
}

