/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.xmod.jei;

import com.glodblock.github.glodium.recipe.stack.IngredientStack;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.advanced_ae.xmod.jei.ReactionChamberCategory;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation TEXTURE = AdvancedAE.makeId("textures/guis/emi.png");
    private static final ResourceLocation ID = AdvancedAE.makeId("core");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new ReactionChamberCategory(jeiHelpers)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(ReactionChamberCategory.RECIPE_TYPE, List.copyOf(recipeManager.byType(ReactionChamberRecipe.TYPE).stream().map(RecipeHolder::value).toList()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack chamber = AAEBlocks.REACTION_CHAMBER.stack();
        registration.addRecipeCatalyst(chamber, new RecipeType[]{ReactionChamberCategory.RECIPE_TYPE});
    }

    public static Ingredient stackOf(IngredientStack.Item stack) {
        if (!stack.isEmpty()) {
            return Ingredient.of(Arrays.stream(((Ingredient)stack.getIngredient()).getItems()).map(oldStack -> oldStack.copyWithCount(stack.getAmount())));
        }
        return (Ingredient)IngredientStack.Item.EMPTY.getIngredient();
    }

    public static List<FluidStack> stackOf(IngredientStack.Fluid stack) {
        FluidIngredient ingredient = (FluidIngredient)stack.getIngredient();
        return Arrays.stream(ingredient.getStacks()).map(oldStack -> oldStack.copyWithAmount(stack.getAmount())).toList();
    }
}

