/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.core.network.ClientboundPacket;
import appeng.core.network.CustomAppEngPayload;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;

public record EnabledPatternsUpdatePacket(List<Boolean> enabledPatterns) implements ClientboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, EnabledPatternsUpdatePacket> STREAM_CODEC = StreamCodec.ofMember(EnabledPatternsUpdatePacket::write, EnabledPatternsUpdatePacket::decode);
    public static final CustomPacketPayload.Type<EnabledPatternsUpdatePacket> TYPE = CustomAppEngPayload.createType((String)"aae_crafter_enabled_buttons");

    public CustomPacketPayload.Type<EnabledPatternsUpdatePacket> type() {
        return TYPE;
    }

    public static EnabledPatternsUpdatePacket decode(RegistryFriendlyByteBuf stream) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        int size = stream.readInt();
        for (int x = 0; x < size; ++x) {
            list.add(stream.readBoolean());
        }
        return new EnabledPatternsUpdatePacket(list);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeInt(this.enabledPatterns.size());
        for (Boolean entry : this.enabledPatterns) {
            data.writeBoolean(entry.booleanValue());
        }
    }

    public void handleOnClient(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof QuantumCrafterScreen) {
            QuantumCrafterScreen screen2 = (QuantumCrafterScreen)screen;
            screen2.updateEnabledButtons(this.enabledPatterns);
        }
    }
}

