/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.parts;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.util.AEColor;
import appeng.client.render.BlockEntityRenderHelper;
import appeng.core.AppEng;
import appeng.hooks.ticking.TickHandler;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractMonitorPart;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.client.renderer.AAEBlockEntityRenderHelper;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.mixins.MixinAbstractMonitorPartAccessor;

public class ThroughputMonitorPart
extends AbstractMonitorPart
implements IGridTickable {
    @PartModels
    public static final ResourceLocation MODEL_OFF = AppEng.makeId((String)"part/storage_monitor_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = AppEng.makeId((String)"part/storage_monitor_on");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_OFF = AppEng.makeId((String)"part/storage_monitor_locked_off");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_ON = AppEng.makeId((String)"part/storage_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL});
    private long lastUpdateTick = -1L;
    protected long amountAtLastUpdate = -1L;
    protected long lastReportedValue = -1L;
    protected String lastHumanReadableValue = "";
    private WorkRoutine workRoutine = WorkRoutine.SECOND;
    private WorkRoutine lastWorkRoutine = WorkRoutine.SECOND;
    private static final int positiveColor = AEColor.GREEN.mediumVariant;
    private static final int negativeColor = AEColor.RED.mediumVariant;

    public ThroughputMonitorPart(IPartItem<?> partItem) {
        super(partItem, false);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putLong("lastValue", this.lastReportedValue);
        data.putString("throughput", this.lastHumanReadableValue);
        data.putInt("routine", this.workRoutine.ordinal());
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.lastReportedValue = data.getLong("lastValue");
        this.lastHumanReadableValue = data.getString("throughput");
        this.workRoutine = WorkRoutine.fromInt(data.getInt("routine"));
    }

    public void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeLong(this.lastUpdateTick);
        data.writeLong(this.amountAtLastUpdate);
        data.writeLong(this.lastReportedValue);
        data.writeUtf(this.lastHumanReadableValue);
        data.writeEnum((Enum)this.workRoutine);
    }

    public boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean needRedraw = super.readFromStream(data);
        this.lastUpdateTick = data.readLong();
        this.amountAtLastUpdate = data.readLong();
        long reportedValue = data.readLong();
        boolean bl = this.lastReportedValue > 0L && reportedValue < 0L || this.lastReportedValue < 0L && reportedValue > 0L;
        this.lastReportedValue = reportedValue;
        this.lastHumanReadableValue = data.readUtf();
        this.workRoutine = (WorkRoutine)data.readEnum(WorkRoutine.class);
        return needRedraw |= bl;
    }

    public void writeVisualStateToNBT(CompoundTag data) {
        super.writeVisualStateToNBT(data);
        data.putLong("lastValue", this.lastReportedValue);
        data.putString("throughput", this.lastHumanReadableValue);
        data.putInt("routine", this.workRoutine.ordinal());
    }

    public void readVisualStateFromNBT(CompoundTag data) {
        super.readVisualStateFromNBT(data);
        this.lastReportedValue = data.getLong("lastValue");
        this.lastHumanReadableValue = data.getString("throughput");
        this.workRoutine = WorkRoutine.fromInt(data.getInt("routine"));
    }

    public boolean onUseItemOn(ItemStack heldItem, Player player, InteractionHand hand, Vec3 pos) {
        if (heldItem == ItemStack.EMPTY) {
            return super.onUseWithoutItem(player, pos);
        }
        if (heldItem.is(AAEItems.MONITOR_CONFIGURATOR.asItem())) {
            if (!this.isClientSide()) {
                this.cycleWorkRoutine();
            }
            return true;
        }
        return super.onUseItemOn(heldItem, player, hand, pos);
    }

    private void cycleWorkRoutine() {
        this.workRoutine = WorkRoutine.cycle(this.workRoutine);
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    @Nullable
    private AEKey getConfiguredItem() {
        return ((MixinAbstractMonitorPartAccessor)((Object)this)).getConfiguredItem();
    }

    protected void configureWatchers() {
        if (this.getConfiguredItem() != null) {
            this.updateState(TickHandler.instance().getCurrentTick());
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        } else {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().sleepDevice(node));
        }
        super.configureWatchers();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        if (this.isActive() && this.getConfiguredItem() != null) {
            String sign;
            poseStack.pushPose();
            BlockOrientation orientation = BlockOrientation.get((Direction)this.getSide(), (int)this.getSpin());
            poseStack.translate(0.5, 0.5, 0.5);
            BlockEntityRenderHelper.rotateToFace((PoseStack)poseStack, (BlockOrientation)orientation);
            poseStack.translate(0.0, 0.1, 0.5);
            BlockEntityRenderHelper.renderItem2dWithAmount((PoseStack)poseStack, (MultiBufferSource)buffers, (AEKey)this.getDisplayed(), (long)((MixinAbstractMonitorPartAccessor)((Object)this)).getAmount(), (boolean)((MixinAbstractMonitorPartAccessor)((Object)this)).getCanCraft(), (float)0.3f, (float)-0.15f, (int)this.getColor().contrastTextColor, (Level)this.getLevel());
            poseStack.translate(0.0f, -0.23f, 0.0f);
            String string = this.lastReportedValue > 0L ? "+" : (sign = this.lastReportedValue == 0L ? "" : "-");
            int color = this.lastReportedValue > 0L ? positiveColor : (this.lastReportedValue == 0L ? this.getColor().contrastTextColor : negativeColor);
            MutableComponent text = switch (this.workRoutine.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> AAEText.OverdriveThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                case 1 -> AAEText.ThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                case 2 -> AAEText.SlowThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
            };
            AAEBlockEntityRenderHelper.renderString(poseStack, buffers, (Component)text, color);
            poseStack.popPose();
        }
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        super.onMainNodeStateChanged(reason);
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(20, 400, !this.isActive() || this.getConfiguredItem() == null);
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int i) {
        if (!this.getMainNode().isActive() || this.getConfiguredItem() == null) {
            this.resetState();
            return TickRateModulation.SLEEP;
        }
        long currentTick = TickHandler.instance().getCurrentTick();
        long tickAmount = currentTick - this.lastUpdateTick;
        float timeInSeconds = (float)tickAmount / 20.0f;
        if (this.lastUpdateTick == -1L || timeInSeconds <= 0.0f) {
            this.updateState(currentTick);
            this.lastHumanReadableValue = "-";
            return TickRateModulation.URGENT;
        }
        if (this.workRoutine == this.lastWorkRoutine) {
            float amountPerSecond = (float)(this.getAmount() - this.amountAtLastUpdate) / timeInSeconds;
            this.lastReportedValue = Math.round(switch (this.workRoutine.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> amountPerSecond / 20.0f;
                case 1 -> amountPerSecond;
                case 2 -> amountPerSecond * 60.0f;
            });
            this.lastHumanReadableValue = this.getConfiguredItem().formatAmount(Math.abs(this.lastReportedValue), AmountFormat.SLOT);
        } else {
            this.lastHumanReadableValue = "-";
        }
        this.updateState(currentTick);
        this.getHost().markForUpdate();
        return TickRateModulation.SLOWER;
    }

    private void resetState() {
        this.lastUpdateTick = -1L;
        this.amountAtLastUpdate = -1L;
        this.lastHumanReadableValue = "";
    }

    private void updateState(long tick) {
        this.lastUpdateTick = tick;
        this.amountAtLastUpdate = this.getAmount();
        this.lastWorkRoutine = this.workRoutine;
    }

    private static enum WorkRoutine {
        TICK,
        SECOND,
        MINUTE;


        public static WorkRoutine cycle(WorkRoutine routine) {
            return switch (routine.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SECOND;
                case 1 -> MINUTE;
                case 2 -> TICK;
            };
        }

        public static WorkRoutine fromInt(int value) {
            return switch (value) {
                case 0 -> TICK;
                case 2 -> MINUTE;
                default -> SECOND;
            };
        }
    }
}

