/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.upgrades;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.helpers.MagnetHelpers;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.armors.QuantumLeggings;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.appflux.AppliedFluxPlugin;
import net.pedroksl.advanced_ae.xmod.curios.CuriosPlugin;
import org.apache.commons.lang3.mutable.MutableObject;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class UpgradeCards {
    public static boolean walkSpeed(Level level, Player player, ItemStack stack) {
        boolean isNotFlying;
        QuantumArmorBase armor;
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chest.getItem();
        boolean canFly = item instanceof QuantumArmorBase && (armor = (QuantumArmorBase)item).isUpgradeEnabledAndPowered(chest, UpgradeType.FLIGHT);
        boolean bl = isNotFlying = !player.getAbilities().flying;
        if (!player.isSprinting() && (canFly || isNotFlying) && !player.isInWaterOrBubble()) {
            QuantumLeggings legs;
            UpgradeType upgrade = UpgradeType.WALK_SPEED;
            Item item2 = stack.getItem();
            if (item2 instanceof QuantumLeggings && (legs = (QuantumLeggings)item2).isUpgradeEnabledAndPowered(stack, upgrade)) {
                return UpgradeCards.processMovementSpeed(upgrade, player, canFly, stack, chest);
            }
            if (canFly && player.getAbilities().flying) {
                return UpgradeCards.processFlightSpeed(player, chest);
            }
        }
        return false;
    }

    public static boolean sprintSpeed(Level level, Player player, ItemStack stack) {
        boolean isNotFlying;
        QuantumArmorBase armor;
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chest.getItem();
        boolean canFly = item instanceof QuantumArmorBase && (armor = (QuantumArmorBase)item).isUpgradeEnabledAndPowered(chest, UpgradeType.FLIGHT);
        boolean bl = isNotFlying = player.fallDistance <= 0.0f && !player.isFallFlying();
        if (player.isSprinting() && (canFly || isNotFlying) && !player.isInWaterOrBubble()) {
            QuantumLeggings legs;
            UpgradeType upgrade = UpgradeType.SPRINT_SPEED;
            Item item2 = stack.getItem();
            if (item2 instanceof QuantumLeggings && (legs = (QuantumLeggings)item2).isUpgradeEnabledAndPowered(stack, upgrade)) {
                return UpgradeCards.processMovementSpeed(upgrade, player, canFly, stack, chest);
            }
            if (canFly && player.getAbilities().flying) {
                return UpgradeCards.processFlightSpeed(player, chest);
            }
        }
        return false;
    }

    public static boolean swimSpeed(Level level, Player player, ItemStack stack) {
        if (player.isInWaterOrBubble()) {
            QuantumLeggings legs;
            UpgradeType upgrade = UpgradeType.SWIM_SPEED;
            Item item = stack.getItem();
            if (item instanceof QuantumLeggings && (legs = (QuantumLeggings)item).isUpgradeEnabledAndPowered(stack, upgrade)) {
                return UpgradeCards.processMovementSpeed(upgrade, player, false, stack, null);
            }
        }
        return false;
    }

    private static boolean processMovementSpeed(UpgradeType upgrade, Player player, boolean canFly, ItemStack stack, ItemStack chest) {
        boolean slowDown = true;
        float value = upgrade.getSettings().multiplier * (float)((Integer)stack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)upgrade), (Object)0)).intValue();
        if (!(value > 0.0f) || !(value < 1.0f)) {
            slowDown = false;
            value /= 25.0f;
        }
        if (canFly && player.getAbilities().flying && chest != null) {
            value = !slowDown ? (value += (float)((Integer)chest.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.FLIGHT), (Object)0)).intValue() / 25.0f) : (float)((Integer)chest.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.FLIGHT), (Object)0)).intValue() / 25.0f;
            slowDown = false;
        }
        if (slowDown && player.onGround()) {
            Vec3 motion = player.getDeltaMovement();
            player.setDeltaMovement(motion.multiply((double)value, 1.0, (double)value));
            return true;
        }
        if (!slowDown && value > 0.0f) {
            if (!player.onGround()) {
                value /= 4.0f;
            }
            if (player.zza < 0.0f) {
                value /= 2.0f;
            }
            player.moveRelative(value, new Vec3((double)Math.signum(player.xxa), (double)Math.signum(player.yya), (double)Math.signum(player.zza)));
            return true;
        }
        return false;
    }

    private static boolean processFlightSpeed(Player player, ItemStack chest) {
        float value = (float)((Integer)chest.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.FLIGHT), (Object)0)).intValue() / 25.0f;
        if (value > 0.0f) {
            if (!player.onGround()) {
                value /= 4.0f;
            }
            if (player.zza < 0.0f) {
                value /= 2.0f;
            }
            player.moveRelative(value, new Vec3((double)Math.signum(player.xxa), (double)Math.signum(player.yya), (double)Math.signum(player.zza)));
            return true;
        }
        return false;
    }

    public static boolean jumpHeight(Level level, Player player, ItemStack stack) {
        if (!player.isInWaterOrBubble() && !player.isFallFlying()) {
            float value;
            QuantumBoots boots;
            UpgradeType upgrade = UpgradeType.JUMP_HEIGHT;
            Item item = stack.getItem();
            if (item instanceof QuantumBoots && (boots = (QuantumBoots)item).isUpgradeEnabledAndPowered(stack, upgrade) && (value = upgrade.getSettings().multiplier * (float)((Integer)stack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)upgrade), (Object)-1)).intValue() / 8.0f) > 0.0f) {
                if (player.isSprinting()) {
                    value *= 2.0f;
                }
                player.moveRelative(value, new Vec3(0.0, 1.0, 0.0));
                return true;
            }
        }
        return false;
    }

    public static boolean autoFeed(Level level, Player player, ItemStack stack) {
        QuantumHelmet helmet;
        Item item;
        if (player.getFoodData().needsFood() && (item = stack.getItem()) instanceof QuantumHelmet && (helmet = (QuantumHelmet)item).isUpgradeEnabledAndPowered(stack, UpgradeType.AUTO_FEED) && helmet.getLinkedPosition(stack) != null) {
            MutableObject errorHolder = new MutableObject();
            IGrid grid = helmet.getLinkedGrid(stack, level, arg_0 -> ((MutableObject)errorHolder).setValue(arg_0));
            if (grid != null) {
                IStorageService storage = grid.getStorageService();
                List filter = (List)stack.getOrDefault(AAEComponents.UPGRADE_FILTER.get((Object)UpgradeType.AUTO_FEED), new ArrayList());
                for (GenericStack genStack : filter) {
                    FoodProperties foodProperties;
                    AEItemKey itemKey;
                    ItemStack foodStack;
                    AEKey aEKey;
                    if (storage.getInventory().extract(genStack.what(), 1L, Actionable.SIMULATE, IActionSource.ofPlayer((Player)player)) <= 0L || !((aEKey = genStack.what()) instanceof AEItemKey) || !(foodStack = (itemKey = (AEItemKey)aEKey).toStack()).has(DataComponents.FOOD) || (foodProperties = (FoodProperties)foodStack.get(DataComponents.FOOD)) == null) continue;
                    storage.getInventory().extract(genStack.what(), 1L, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                    foodStack = foodStack.finishUsingItem(level, (LivingEntity)player);
                    if (!foodStack.isEmpty()) {
                        storage.getInventory().insert((AEKey)AEItemKey.of((ItemStack)foodStack), (long)foodStack.getCount(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean autoStock(Level level, Player player, ItemStack stack) {
        QuantumHelmet helmet;
        Item item = stack.getItem();
        if (item instanceof QuantumHelmet && (helmet = (QuantumHelmet)item).isUpgradeEnabledAndPowered(stack, UpgradeType.AUTO_STOCK) && helmet.getLinkedPosition(stack) != null) {
            if (player.containerMenu != null && !player.containerMenu.getCarried().isEmpty()) {
                return false;
            }
            MutableObject errorHolder = new MutableObject();
            IGrid grid = helmet.getLinkedGrid(stack, level, arg_0 -> ((MutableObject)errorHolder).setValue(arg_0));
            if (grid != null) {
                IStorageService storage = grid.getStorageService();
                List filter = (List)stack.getOrDefault(AAEComponents.UPGRADE_FILTER.get((Object)UpgradeType.AUTO_STOCK), new ArrayList());
                boolean didSomething = false;
                KeyCounter inventory = storage.getInventory().getAvailableStacks();
                for (GenericStack genStack : filter) {
                    AEKey aEKey = genStack.what();
                    if (!(aEKey instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)aEKey;
                    long desiredAmount = genStack.amount();
                    int currentAmount = 0;
                    ArrayList<Integer> slots = new ArrayList<Integer>();
                    for (int x = 0; x < player.getInventory().getContainerSize(); ++x) {
                        ItemStack currentStack = player.getInventory().getItem(x);
                        if (!itemKey.is((ItemLike)currentStack.getItem())) continue;
                        currentAmount += currentStack.getCount();
                        slots.add(x);
                    }
                    long amountDelta = desiredAmount - (long)currentAmount;
                    if (amountDelta > 0L && inventory.get((AEKey)itemKey) > 0L) {
                        long extracted = storage.getInventory().extract(genStack.what(), amountDelta, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                        ItemStack stackToInsert = itemKey.toStack((int)extracted);
                        player.addItem(stackToInsert);
                        storage.getInventory().insert(genStack.what(), (long)stackToInsert.getCount(), Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                        didSomething |= extracted > 0L;
                        continue;
                    }
                    if (amountDelta >= 0L) continue;
                    amountDelta = -amountDelta;
                    long inserted = storage.getInventory().insert(genStack.what(), amountDelta, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                    int amountToLeave = (int)desiredAmount + (int)(amountDelta - inserted);
                    for (Integer slot : slots) {
                        ItemStack item2 = player.getInventory().getItem(slot.intValue()).copy();
                        int amountToSet = Math.max(0, Math.min(item2.getCount(), amountToLeave));
                        item2.setCount(amountToSet);
                        player.getInventory().setItem(slot.intValue(), item2);
                        amountToLeave = Math.max(0, amountToLeave - amountToSet);
                    }
                    didSomething |= inserted > 0L;
                }
                return didSomething;
            }
        }
        return false;
    }

    public static boolean magnet(Level level, Player player, ItemStack stack) {
        QuantumHelmet helmet;
        Item item;
        if (!player.isSpectator() && (item = stack.getItem()) instanceof QuantumHelmet && (helmet = (QuantumHelmet)item).isUpgradeEnabledAndPowered(stack, UpgradeType.MAGNET, level)) {
            Integer range = (Integer)stack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.MAGNET), (Object)5);
            Vec3 pos = player.position();
            AABB area = MagnetHelpers.getBoundingBox(pos, range);
            List filter = (List)stack.getOrDefault(AAEComponents.UPGRADE_FILTER.get((Object)UpgradeType.MAGNET), new ArrayList());
            Boolean blacklist = (Boolean)stack.getOrDefault(AAEComponents.UPGRADE_EXTRA.get((Object)UpgradeType.MAGNET), (Object)true);
            List items = level.getEntities((EntityTypeTest)EntityType.ITEM, area, obj -> MagnetHelpers.validEntities(obj, player, filter, blacklist));
            items.forEach(itemEntity -> {
                if (!level.isClientSide() && player.getInventory().getSlotWithRemainingSpace(itemEntity.getItem()) != -1) {
                    itemEntity.playerTouch(player);
                }
                itemEntity.setPos(pos);
            });
            if (!level.isClientSide()) {
                List xps = level.getEntitiesOfClass(ExperienceOrb.class, area);
                xps.forEach(xp -> {
                    xp.invulnerableTime = 0;
                    player.takeXpDelay = 0;
                    xp.playerTouch(player);
                });
            }
            return true;
        }
        return false;
    }

    public static boolean regeneration(Level level, Player player, ItemStack stack) {
        QuantumChestplate chest;
        Item item = stack.getItem();
        if (item instanceof QuantumChestplate && (chest = (QuantumChestplate)item).isUpgradeEnabledAndPowered(stack, UpgradeType.REGENERATION)) {
            player.heal((float)(0.1 * (double)AAEConfig.instance().getRenegerationPerTick()));
            return true;
        }
        return false;
    }

    public static boolean recharging(Level level, Player player, ItemStack stack) {
        QuantumArmorBase armor;
        Item item = stack.getItem();
        if (item instanceof QuantumArmorBase && (armor = (QuantumArmorBase)item).isUpgradeEnabledAndPowered(stack, UpgradeType.CHARGING) && armor.getLinkedPosition(stack) != null) {
            MutableObject errorHolder = new MutableObject();
            IGrid grid = armor.getLinkedGrid(stack, level, arg_0 -> ((MutableObject)errorHolder).setValue(arg_0));
            if (grid != null) {
                IEnergyService energy = grid.getEnergyService();
                double currentPower = armor.getAECurrentPower(stack);
                double rate = armor.getChargeRate(stack);
                int afRate = Integer.MAX_VALUE;
                double maxPower = armor.getAEMaxPower(stack);
                double neededPower = Math.min(rate, maxPower - currentPower);
                if (neededPower > 0.0 && Addons.APPFLUX.isLoaded()) {
                    neededPower = Math.min((double)afRate, maxPower - currentPower);
                    neededPower = AppliedFluxPlugin.rechargeAeStorageItem(grid, neededPower, player, stack, armor);
                }
                if (neededPower > 0.0 && energy.getStoredPower() > 0.0) {
                    double extracted = energy.extractAEPower(rate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    double remainder = armor.injectAEPower(stack, extracted, Actionable.MODULATE);
                    energy.injectPower(remainder, Actionable.MODULATE);
                }
                if (stack.getItem() instanceof QuantumChestplate) {
                    Optional<ICuriosItemHandler> optionalInv;
                    for (int i = 0; i < 36; ++i) {
                        ItemStack item2 = player.getInventory().getItem(i);
                        if (item2.isEmpty()) continue;
                        UpgradeCards.rechargeItem(player, item2, grid, rate, energy);
                    }
                    if (!player.getOffhandItem().isEmpty()) {
                        UpgradeCards.rechargeItem(player, player.getOffhandItem(), grid, rate, energy);
                    }
                    if (Addons.CURIOS.isLoaded() && (optionalInv = CuriosPlugin.getCuriosInventory(player)).isPresent()) {
                        ICuriosItemHandler curiosInventory = optionalInv.get();
                        IItemHandlerModifiable handler = curiosInventory.getEquippedCurios();
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack item3 = handler.getStackInSlot(i);
                            if (item3.isEmpty()) continue;
                            UpgradeCards.rechargeItem(player, item3, grid, rate, energy);
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void rechargeItem(Player player, ItemStack stack, IGrid grid, double rate, IEnergyService energyService) {
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        int afRate = Integer.MAX_VALUE;
        if (cap != null && cap.canReceive() && cap.getEnergyStored() < cap.getMaxEnergyStored()) {
            if (Addons.APPFLUX.isLoaded()) {
                AppliedFluxPlugin.rechargeEnergyStorage(grid, afRate, IActionSource.ofPlayer((Player)player), cap);
            }
            if (energyService.getStoredPower() > 0.0) {
                double extracted = energyService.extractAEPower(rate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                int inserted = cap.receiveEnergy((int)extracted, false);
                energyService.injectPower(extracted - (double)inserted, Actionable.MODULATE);
            }
        }
    }
}

