/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIconButton;

public class AAEToggleButton
extends AAEIconButton
implements ITooltip {
    private final Listener listener;
    private final AAEIcon iconOn;
    private final AAEIcon iconOff;
    private List<Component> tooltipOn = Collections.emptyList();
    private List<Component> tooltipOff = Collections.emptyList();
    private boolean state;

    public AAEToggleButton(AAEIcon on, AAEIcon off, Component displayName, Component displayHint, Listener listener) {
        this(on, off, listener);
        this.setTooltipOn(List.of(displayName, displayHint));
        this.setTooltipOff(List.of(displayName, displayHint));
    }

    public AAEToggleButton(AAEIcon on, AAEIcon off, Listener listener) {
        super(null);
        this.iconOn = on;
        this.iconOff = off;
        this.listener = listener;
    }

    public void setTooltipOn(List<Component> lines) {
        this.tooltipOn = lines;
    }

    public void setTooltipOff(List<Component> lines) {
        this.tooltipOff = lines;
    }

    public void onPress() {
        this.listener.onChange(!this.state);
    }

    public void setState(boolean isOn) {
        this.state = isOn;
    }

    @Override
    protected AAEIcon getIcon() {
        return this.state ? this.iconOn : this.iconOff;
    }

    @Override
    public List<Component> getTooltipMessage() {
        return this.state ? this.tooltipOn : this.tooltipOff;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return super.isTooltipAreaVisible() && !this.getTooltipMessage().isEmpty();
    }

    @FunctionalInterface
    public static interface Listener {
        public void onChange(boolean var1);
    }
}

