/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import org.jetbrains.annotations.NotNull;

public class AAESlider
extends ExtendedSlider {
    protected static final WidgetSprites SPRITES = new WidgetSprites(AppEng.makeId((String)"button"), AppEng.makeId((String)"button_disabled"), AppEng.makeId((String)"button_highlighted"));
    private final Consumer<Double> setter;

    public AAESlider(double minValue, double maxValue, double currentValue, float multiplier) {
        this(minValue, maxValue, currentValue, multiplier, value -> {});
    }

    public AAESlider(double minValue, double maxValue, double currentValue, float multiplier, Consumer<Double> setter) {
        super(0, 0, 100, 20, (Component)Component.empty(), (Component)Component.empty(), minValue, maxValue, currentValue, (double)multiplier, 0, true);
        this.setter = setter;
    }

    public void setValues(double minValue, double maxValue, double currentValue, float multiplier) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = multiplier;
        this.setValue(currentValue);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        int minX = this.getX() + 4;
        int maxX = this.getX() + this.getWidth() - 4;
        int middleX = this.getX() + this.getWidth() / 2;
        int middleY = this.getY() + this.getHeight() / 2;
        int minY = this.getY() + this.getHeight() / 4;
        int maxY = this.getY() + 3 * this.getHeight() / 4;
        int backColor = 0xADB0C4 | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
        int lineColor = 0x413F54 | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
        guiGraphics.fill(minX - 6, minY - 2, maxX + 6, maxY + 2, -1);
        guiGraphics.fill(minX - 5, minY - 1, maxX + 5, maxY + 1, backColor);
        guiGraphics.hLine(minX, maxX, middleY, lineColor);
        guiGraphics.vLine(minX, minY, maxY, lineColor);
        guiGraphics.vLine(maxX, minY, maxY, lineColor);
        String minText = this.getValueText(this.minValue);
        guiGraphics.drawString(font, minText, minX - font.width(minText) / 2, this.getY() - 5, lineColor, false);
        String maxText = this.getValueText(this.maxValue);
        guiGraphics.drawString(font, maxText, maxX - font.width(maxText) / 2, this.getY() - 5, lineColor, false);
        String currentText = this.getValueText(this.getValue());
        guiGraphics.drawString(font, currentText, middleX - font.width(currentText) / 2, this.getY() - 5, lineColor, false);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(this.getHandleSprite(), this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY() + 4, 8, this.getHeight() - 8);
    }

    private String getValueText(double value) {
        if (this.stepSize < 1.0) {
            return String.format("%.1f", value);
        }
        return String.format("%.0f", value);
    }

    protected void applyValue() {
        this.setter.accept(this.getValue());
    }

    @NotNull
    protected ResourceLocation getHandleSprite() {
        return SPRITES.get(this.active, this.isHovered());
    }
}

