/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.menu.implementations.UpgradeableMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.parts.StockExportBusPart;
import net.pedroksl.advanced_ae.gui.StockExportBusMenu;
import org.jetbrains.annotations.NotNull;

public class StockExportBusScreen
extends UpgradeableScreen<StockExportBusMenu> {
    private final SettingToggleButton<RedstoneMode> redstoneMode = new ServerSettingToggleButton(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
    private final SettingToggleButton<YesNo> craftMode;
    private final SettingToggleButton<SchedulingMode> schedulingMode;

    public StockExportBusScreen(StockExportBusMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)this.redstoneMode);
        if (((StockExportBusPart)menu.getHost()).getConfigManager().hasSetting(Settings.CRAFT_ONLY)) {
            this.craftMode = new ServerSettingToggleButton(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
            this.addToLeftToolbar((Button)this.craftMode);
        } else {
            this.craftMode = null;
        }
        if (((StockExportBusPart)menu.getHost()).getConfigManager().hasSetting(Settings.SCHEDULING_MODE)) {
            this.schedulingMode = new ServerSettingToggleButton(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
            this.addToLeftToolbar((Button)this.schedulingMode);
        } else {
            this.schedulingMode = null;
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set((Enum)((StockExportBusMenu)this.menu).getRedStoneMode());
        this.redstoneMode.setVisibility(((StockExportBusMenu)this.menu).hasUpgrade((ItemLike)AEItems.REDSTONE_CARD));
        if (this.craftMode != null) {
            this.craftMode.set((Enum)((StockExportBusMenu)this.menu).getCraftingMode());
            this.craftMode.setVisibility(((StockExportBusMenu)this.menu).hasUpgrade((ItemLike)AEItems.CRAFTING_CARD));
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.set((Enum)((StockExportBusMenu)this.menu).getSchedulingMode());
        }
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        Slot slot;
        assert (this.minecraft != null);
        if (this.minecraft.options.keyPickItem.matchesMouse(btn) && this.isValidSlot(slot = this.findSlot(xCoord, yCoord))) {
            ((StockExportBusMenu)this.menu).openAmountMenu(slot.index);
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        if (((StockExportBusMenu)this.menu).getCarried().isEmpty() && this.isValidSlot(this.hoveredSlot)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.getTooltipFromContainerItem(this.hoveredSlot.getItem()));
            GenericStack unwrapped = GenericStack.fromItemStack((ItemStack)this.hoveredSlot.getItem());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.Amount, (GenericStack)unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else {
            super.renderTooltip(guiGraphics, x, y);
        }
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(10.0f, 17.0f, 0.0f);
        poseStack.scale(0.7f, 0.7f, 1.0f);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        guiGraphics.drawString(this.font, (Component)AAEText.SetAmountButtonHint.text(), 0, 0, color.toARGB(), false);
        poseStack.popPose();
    }

    private boolean isValidSlot(Slot slot) {
        return slot != null && slot.isActive() && slot.hasItem() && ((StockExportBusMenu)this.menu).isConfigSlot(slot);
    }
}

