/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.api;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.parts.IPart;
import appeng.api.storage.ISubMenuHost;
import appeng.blockentity.networking.CableBusBlockEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IDirectionalOutputHost
extends ISubMenuHost {
    public BlockOrientation getOrientation();

    public BlockPos getBlockPos();

    public Level getLevel();

    public EnumSet<RelativeSide> getAllowedOutputs();

    public void updateOutputSides(EnumSet<RelativeSide> var1);

    default public ItemStack getAdjacentBlock(RelativeSide side) {
        BlockEntity blockEntity;
        Direction dir = this.getOrientation().getSide(side);
        BlockPos blockPos = this.getBlockPos().relative(dir);
        Level level = this.getLevel();
        if (level == null) {
            return null;
        }
        BlockState blockState = level.getBlockState(blockPos);
        ItemStack itemStack = blockState.getBlock().asItem().getDefaultInstance();
        if (blockState.hasBlockEntity() && (blockEntity = level.getBlockEntity(blockPos)) != null) {
            if (blockEntity instanceof CableBusBlockEntity) {
                CableBusBlockEntity cable = (CableBusBlockEntity)blockEntity;
                IPart part = cable.getPart(dir.getOpposite());
                if (part != null) {
                    itemStack = new ItemStack((ItemLike)part.getPartItem().asItem(), 1);
                }
            } else {
                blockEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess());
            }
        }
        return itemStack;
    }
}

