/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NormalMarkerEntity
extends QpEntity
implements QuarryMarker,
ClientSync {
    public static final int MAX_SEARCH = 256;
    @NotNull
    private Status status = Status.NOT_CONNECTED;
    @Nullable
    private Link link;

    public NormalMarkerEntity(BlockPos pos, BlockState blockState) {
        super(PlatformAccess.getAccess().registerObjects().getBlockEntityType((QpBlock)blockState.getBlock()).orElseThrow(), pos, blockState);
    }

    void tryConnect(Consumer<Component> messageSender) {
        if (!this.enabled) {
            messageSender.accept((Component)Component.translatable((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.getBlockState().getBlock().getName()}));
            return;
        }
        if (this.status.isConnected()) {
            messageSender.accept((Component)Component.literal((String)"This marker already has connection"));
            return;
        }
        assert (this.level != null);
        Optional<NormalMarkerEntity> xMarker = NormalMarkerEntity.getMarker(this.level, this.getBlockPos(), this.getType(), Direction.Axis.X);
        Optional<NormalMarkerEntity> zMarker = NormalMarkerEntity.getMarker(this.level, this.getBlockPos(), this.getType(), Direction.Axis.Z);
        Optional xzMarker = xMarker.flatMap(e -> NormalMarkerEntity.getMarker(this.level, e.getBlockPos(), e.getType(), Direction.Axis.Z));
        Optional zxMarker = zMarker.flatMap(e -> NormalMarkerEntity.getMarker(this.level, e.getBlockPos(), e.getType(), Direction.Axis.X));
        Optional<NormalMarkerEntity> yMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).filter(y -> !this.level.isOutsideBuildHeight(y)).boxed().flatMap(d -> Stream.concat(Stream.of(this.getBlockPos()), Stream.of(xMarker.stream(), zMarker.stream()).flatMap(Function.identity()).map(BlockEntity::getBlockPos)).map(p -> p.relative(Direction.Axis.Y, d.intValue())).flatMap(p -> this.level.getBlockEntity(p, this.getType()).stream())).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).filter(e -> !e.status.isConnected()).findAny();
        BiFunction<BlockEntity, BlockEntity, Link> f = (x, z) -> new Link(Stream.concat(Stream.of(this.getBlockPos(), x.getBlockPos(), z.getBlockPos()), yMarker.map(BlockEntity::getBlockPos).stream()).toList());
        Optional maybeLink = xMarker.flatMap(x -> zMarker.map(z -> (Link)f.apply((BlockEntity)x, (BlockEntity)z))).or(() -> xMarker.flatMap(x -> xzMarker.map(z -> (Link)f.apply((BlockEntity)x, (BlockEntity)z)))).or(() -> zMarker.flatMap(z -> zxMarker.map(x -> (Link)f.apply((BlockEntity)x, (BlockEntity)z))));
        maybeLink.ifPresentOrElse(link -> {
            this.setLink((Link)link, true);
            link.markerPos.stream().filter(Predicate.isEqual(this.getBlockPos()).negate()).map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).forEach(e -> e.setLink((Link)link, false));
            messageSender.accept((Component)Component.literal((String)"Marker successfully established connection"));
        }, () -> messageSender.accept((Component)Component.literal((String)"Marker tried to establish connection, but failed")));
    }

    static Optional<NormalMarkerEntity> getMarker(Level level, BlockPos pos, BlockEntityType<?> type, Direction.Axis axis) {
        return IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(d -> pos.relative(axis, d)).flatMap(p -> level.getBlockEntity(p, type).stream()).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).filter(e -> !e.status.isConnected()).findFirst();
    }

    @Override
    public Optional<QuarryMarker.Link> getLink() {
        return Optional.ofNullable(this.link);
    }

    void setLink(@Nullable Link link, boolean isMaster) {
        this.link = link;
        this.status = link != null ? (isMaster ? Status.CONNECTED_MASTER : Status.CONNECTED_SLAVE) : Status.NOT_CONNECTED;
        this.syncToClient();
    }

    @NotNull
    public Status getStatus() {
        return this.status;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putString("status", this.status.name());
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        Status status = Status.valueOf(tag.getString("status"));
        this.status = status == Status.RS_POWERED ? status : Status.NOT_CONNECTED;
    }

    @Override
    public void fromClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.status = Status.valueOf(tag.getString("status"));
        this.link = Link.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("link")).result().orElse(null);
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putString("status", this.status.name());
        if (this.link != null) {
            tag.put("link", (Tag)Link.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.link).getOrThrow());
        }
        return tag;
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.link != null && this.level != null && !this.level.isClientSide()) {
            this.link.markerPos.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).forEach(m -> m.setLink(null, false));
        }
    }

    @Override
    public Stream<MutableComponent> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(NormalMarkerEntity.detail(ChatFormatting.GREEN, "Status", String.valueOf((Object)this.status)), NormalMarkerEntity.detail(ChatFormatting.GREEN, "Link", String.valueOf(this.link))));
    }

    @Nullable
    public AABB getRenderAabb() {
        if (this.link == null) {
            return null;
        }
        Area area = this.link.area();
        return new AABB((double)area.minX(), (double)area.minY(), (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
    }

    public static enum Status {
        NOT_CONNECTED,
        RS_POWERED,
        CONNECTED_MASTER,
        CONNECTED_SLAVE;


        boolean isConnected() {
            return this == CONNECTED_MASTER || this == CONNECTED_SLAVE;
        }
    }

    protected record Link(List<BlockPos> markerPos) implements QuarryMarker.Link
    {
        static final MapCodec<Link> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(Link::markerPos, (String)"markerPos", (Codec)BlockPos.CODEC.listOf())).apply((Applicative)i, Link::new));

        @Override
        public Area area() {
            int minX = this.markerPos.stream().mapToInt(Vec3i::getX).min().orElseThrow();
            int minY = this.markerPos.stream().mapToInt(Vec3i::getY).min().orElseThrow();
            int minZ = this.markerPos.stream().mapToInt(Vec3i::getZ).min().orElseThrow();
            int maxX = this.markerPos.stream().mapToInt(Vec3i::getX).max().orElseThrow();
            int maxY = this.markerPos.stream().mapToInt(Vec3i::getY).max().orElseThrow();
            int maxZ = this.markerPos.stream().mapToInt(Vec3i::getZ).max().orElseThrow();
            return new Area(minX, minY, minZ, maxX, maxY, maxZ, Direction.UP);
        }

        @Override
        public void remove(Level level) {
            for (BlockPos pos : this.markerPos) {
                level.removeBlock(pos, false);
            }
        }

        @Override
        public List<ItemStack> drops() {
            ItemStack stack = new ItemStack((ItemLike)PlatformAccess.getAccess().registerObjects().markerBlock().get(), this.markerPos.size());
            return List.of(stack);
        }
    }
}

