/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.machine.QpBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record CombinedBlockEntityTicker<T extends BlockEntity>(List<BlockEntityTicker<? super T>> tickers) implements BlockEntityTicker<T>
{
    @SafeVarargs
    @Nullable
    public static <T extends BlockEntity> CombinedBlockEntityTicker<T> of(QpBlock block, Level level, BlockEntityTicker<? super T> ... ts) {
        List<BlockEntityTicker<T>> list = Arrays.stream(ts).filter(Objects::nonNull).toList();
        if (list.isEmpty()) {
            return null;
        }
        return new CombinedBlockEntityTicker<T>(list);
    }

    public void tick(Level world, BlockPos pos, BlockState state, T blockEntity) {
        for (BlockEntityTicker<? super T> blockEntityTicker : this.tickers) {
            blockEntityTicker.tick(world, pos, state, blockEntity);
        }
    }
}

