/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.config.EnableMap;
import com.yogpc.qp.config.QuarryConfig;
import com.yogpc.qp.machine.PowerMap;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.tuple.Pair;

final class QuarryConfigLoader {
    QuarryConfigLoader() {
    }

    static QuarryConfig load(Config config) {
        return QuarryConfigLoader.load(config, () -> false);
    }

    static QuarryConfig load(Config config, BooleanSupplier inDevelop) {
        Pair<ConfigSpec, CommentedConfig> specPair = QuarryConfigLoader.spec(inDevelop);
        ((ConfigSpec)specPair.getKey()).correct(config, (action, path, incorrectValue, correctedValue) -> QuarryPlus.LOGGER.debug("Config corrected '{}': {} -> {}", new Object[]{path, incorrectValue, correctedValue}));
        if (config instanceof CommentedConfig) {
            CommentedConfig c = (CommentedConfig)config;
            c.putAllComments((UnmodifiableCommentedConfig)specPair.getValue());
        }
        Boolean debug = (Boolean)config.get("debug");
        Boolean noEnergy = (Boolean)config.get("noEnergy");
        PowerMap.Quarry quarry = (PowerMap.Quarry)PowerMap.Quarry.CODEC.codec().parse((DynamicOps)JavaOps.INSTANCE, (Object)((Config)config.get("powerMap.quarry")).valueMap()).getOrThrow();
        PowerMap.AdvQuarry advQuarry = (PowerMap.AdvQuarry)PowerMap.AdvQuarry.CODEC.codec().parse((DynamicOps)JavaOps.INSTANCE, (Object)((Config)config.get("powerMap.advQuarry")).valueMap()).getOrThrow();
        PowerMap powerMap = new PowerMap(quarry, advQuarry);
        Config enableMapConfig = (Config)config.get("enableMap");
        EnableMap enableMap = enableMapConfig != null ? EnableMap.from(enableMapConfig.valueMap()) : new EnableMap();
        Double rebornEnergyConversionCoefficient = (Double)config.get("rebornEnergyConversionCoefficient");
        Boolean removeBedrockOnNetherTop = (Boolean)config.get("removeBedrockOnNetherTop");
        Boolean enableChunkLoader = (Boolean)config.get("enableChunkLoader");
        Boolean convertDeepslateOres = (Boolean)config.get("convertDeepslateOres");
        Boolean removeCommonMaterialsByChunkDestroyer = (Boolean)config.get("removeCommonMaterialsByChunkDestroyer");
        Boolean customPlayer = (Boolean)config.get("customPlayer");
        Boolean removeMinecartWithChest = (Boolean)config.get("removeMinecartWithChest");
        return new QuarryConfigImpl(debug, noEnergy, powerMap, enableMap, rebornEnergyConversionCoefficient, removeBedrockOnNetherTop, enableChunkLoader, convertDeepslateOres, removeCommonMaterialsByChunkDestroyer, customPlayer, removeMinecartWithChest);
    }

    static Pair<ConfigSpec, CommentedConfig> spec(BooleanSupplier inDevelop) {
        HashMap comments = new HashMap();
        CommentedConfig specConfig = CommentedConfig.wrap(comments, (ConfigFormat)InMemoryFormat.withUniversalSupport());
        ConfigSpec config = new ConfigSpec((Config)specConfig);
        QuarryConfigLoader.defineBoolean(config, specConfig, "debug", inDevelop.getAsBoolean(), "In debug mode");
        QuarryConfigLoader.defineBoolean(config, specConfig, "noEnergy", false, "Enable No Energy mode");
        QuarryConfigLoader.defineDouble(config, specConfig, "rebornEnergyConversionCoefficient", 0.0625, 0.0, 1.0E10, "[Fabric ONLY] 1E = ?FE");
        QuarryConfigLoader.defineBoolean(config, specConfig, "removeBedrockOnNetherTop", inDevelop.getAsBoolean(), "Remove bedrock at y=127 in Nether");
        QuarryConfigLoader.defineBoolean(config, specConfig, "enableChunkLoader", true, "Enable Chunk Loader in machines");
        QuarryConfigLoader.defineBoolean(config, specConfig, "convertDeepslateOres", false, "Convert Deepslate ores to normal ores");
        QuarryConfigLoader.defineBoolean(config, specConfig, "removeCommonMaterialsByChunkDestroyer", true, "Remove common materials(Base blocks in Over world and the Nether) obtained by Chunk Destroyer");
        QuarryConfigLoader.defineBoolean(config, specConfig, "customPlayer", false, "Enable Custom player mode");
        QuarryConfigLoader.defineBoolean(config, specConfig, "removeMinecartWithChest", true, "Remove Minecart with Chest when processing blocks");
        QuarryConfigLoader.defineInCodec(config, specConfig, "powerMap.quarry", PowerMap.Default.QUARRY);
        QuarryConfigLoader.defineInCodec(config, specConfig, "powerMap.advQuarry", PowerMap.Default.ADV_QUARRY);
        QuarryConfigLoader.defineEnableMap(config, specConfig, "enableMap", EnableMap.getDefault(inDevelop));
        return Pair.of((Object)config, (Object)specConfig);
    }

    static void defineBoolean(ConfigSpec spec, CommentedConfig commentMap, String key, boolean defaultValue, String comment) {
        spec.define(key, (Object)defaultValue);
        commentMap.setComment(key, "%s. Default: %s".formatted(comment, defaultValue));
    }

    static void defineDouble(ConfigSpec spec, CommentedConfig commentMap, String key, double defaultValue, double min, double max, String comment) {
        spec.defineInRange(key, (Comparable)Double.valueOf(defaultValue), (Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max));
        commentMap.setComment(key, "%s. Default: %f, Min: %.1f, Max: %.1f".formatted(comment, defaultValue, min, max));
    }

    static <T extends Record> void defineInCodec(ConfigSpec spec, CommentedConfig commentMap, String prefix, T instance) {
        Class<?> clazz = instance.getClass();
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Instance must be a record, but is " + String.valueOf(instance));
        }
        RecordComponent[] fields = instance.getClass().getRecordComponents();
        try {
            for (RecordComponent field : fields) {
                Method accessor = field.getAccessor();
                Object defaultValue = accessor.invoke(instance, new Object[0]);
                String key = prefix + "." + field.getName();
                if (field.getType().equals(Double.TYPE)) {
                    QuarryConfigLoader.defineDouble(spec, commentMap, key, (Double)defaultValue, 0.0, 1.0E10, field.getName());
                    continue;
                }
                spec.define(key, defaultValue);
                commentMap.setComment(key, "%s. Default: %s".formatted(field.getName(), defaultValue));
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static void defineEnableMap(ConfigSpec spec, CommentedConfig commentMap, String prefix, EnableMap enableMap) {
        Map<String, Boolean> map = enableMap.getMachinesMap();
        for (Map.Entry<String, Boolean> e : map.entrySet()) {
            String key = prefix + "." + e.getKey();
            spec.define(key, (Object)e.getValue());
            EnableMap.EnableOrNot defaultSetting = EnableMap.getDefaultValue(e.getKey());
            if (defaultSetting == EnableMap.EnableOrNot.ALWAYS_OFF) {
                commentMap.setComment(key, "This item can't be enabled in this platform. Configuration will be ignored. (%s)".formatted(e.getKey()));
                continue;
            }
            commentMap.setComment(key, "%s Default: %b".formatted(e.getKey(), e.getValue()));
        }
    }

    record QuarryConfigImpl(boolean debug, boolean noEnergy, PowerMap powerMap, EnableMap enableMap, double rebornEnergyConversionCoefficient, boolean removeBedrockOnNetherTop, boolean enableChunkLoader, boolean convertDeepslateOres, boolean removeCommonMaterialsByChunkDestroyer, boolean customPlayer, boolean removeMinecartWithChest) implements QuarryConfig
    {
    }
}

