/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.me.netdata;

import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.NodeFlag;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;

public enum FlagType {
    LINK,
    NODE;

    public static final Codec<Enum<?>> CODEC;

    public static FlagType byIndex(int index) {
        return FlagType.values()[index];
    }

    static {
        CODEC = Codec.INT.flatXmap(id -> {
            int type = id % 4;
            int ord = id >> 2;
            if (ord < 0) {
                return DataResult.error(() -> "Invalid flag type.");
            }
            if (type == LINK.ordinal()) {
                if (ord >= LinkFlag.values().length) {
                    return DataResult.error(() -> "Invalid flag type.");
                }
                return DataResult.success((Object)((Object)LinkFlag.byIndex(ord)));
            }
            if (type == NODE.ordinal()) {
                if (ord >= NodeFlag.values().length) {
                    return DataResult.error(() -> "Invalid flag type.");
                }
                return DataResult.success((Object)((Object)NodeFlag.byIndex(ord)));
            }
            return DataResult.error(() -> "Invalid flag type.");
        }, e -> {
            if (e.getClass() == LinkFlag.class) {
                return DataResult.success((Object)(e.ordinal() << 2 | LINK.ordinal()));
            }
            if (e.getClass() == NodeFlag.class) {
                return DataResult.success((Object)(e.ordinal() << 2 | NODE.ordinal()));
            }
            return DataResult.error(() -> "Invalid flag type.");
        });
    }
}

