/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import java.util.Objects;
import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DistanceSignDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean isStart;
    private final String signText;
    private Records.WoodAssets wood;

    public DistanceSignDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, Boolean isStart, String distanceText) {
        super(pos, direction, world);
        this.isStart = isStart;
        this.signText = distanceText;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.isStart);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        BlockPos signPos = basePos.above(2).relative(props.offsetDirection.getOpposite());
        world.setBlock(signPos, (BlockState)((BlockState)this.wood.hangingSign().defaultBlockState().setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation))).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateSigns(world, signPos, this.signText);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(BlockPos pos, OrientedDecoration.DirectionProperties props) {
        WorldGenLevel world = this.getWorld();
        world.setBlock(pos.above(3).relative(props.offsetDirection.getOpposite()), (BlockState)this.wood.fence().defaultBlockState().setValue(props.directionProperty, (Comparable)Boolean.valueOf(true)), 3);
        world.setBlock(pos.above(0), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(1), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(2), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(3), (BlockState)this.wood.fence().defaultBlockState().setValue(props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)), 3);
    }

    private void updateSigns(WorldGenLevel structureWorldAccess, BlockPos surfacePos, String text) {
        Objects.requireNonNull(structureWorldAccess.getServer()).execute(() -> {
            BlockEntity signEntity = structureWorldAccess.getBlockEntity(surfacePos);
            if (signEntity instanceof HangingSignBlockEntity) {
                HangingSignBlockEntity signBlockEntity = (HangingSignBlockEntity)signEntity;
                signBlockEntity.setLevel((Level)structureWorldAccess.getLevel());
                SignText signText = signBlockEntity.getText(true);
                signText = signText.setMessage(0, (Component)Component.literal((String)"----------"));
                signText = signText.setMessage(1, (Component)Component.literal((String)"Next Village"));
                signText = signText.setMessage(2, (Component)Component.literal((String)(text + "m")));
                signText = signText.setMessage(3, (Component)Component.literal((String)"----------"));
                signBlockEntity.setText(signText, true);
                SignText signTextBack = signBlockEntity.getText(false);
                signTextBack = signTextBack.setMessage(0, Component.nullToEmpty((String)"----------"));
                signTextBack = signTextBack.setMessage(1, Component.nullToEmpty((String)"Welcome"));
                signTextBack = signTextBack.setMessage(2, Component.nullToEmpty((String)"traveller"));
                signTextBack = signTextBack.setMessage(3, Component.nullToEmpty((String)"----------"));
                signBlockEntity.setText(signTextBack, false);
                signBlockEntity.setChanged();
            }
        });
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

