/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.callbacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.ModSlabsMap;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.countered.terrainslabs.config.MyModConfig;
import net.countered.terrainslabs.persistence.SlabChunkAttachment;
import net.countered.terrainslabs.worldgen.slabfeature.SlabFeatureLogic;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class RegisterCallbacks {
    private static final Map<Item, Block> VEGETATION_ON_TOP_ITEMS = new HashMap<Item, Block>();

    public static void registerCallbacks() {
        RegisterCallbacks.registerPlaceOnTopCallback();
        RegisterCallbacks.registerSlabPlacementCallback();
    }

    private static void registerPlaceOnTopCallback() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            ItemStack item = player.getItemInHand(hand);
            if (item.getItem() == Items.SNOW) {
                BlockPos blockPos = hitResult.getBlockPos().relative(hitResult.getDirection());
                if ((world.getBlockState(blockPos).isAir() || world.getBlockState(blockPos).getBlock() == ModBlocksRegistry.SNOW_ON_TOP) && world.getBlockState(blockPos.below()).getBlock() instanceof SlabBlock && ((SlabType)world.getBlockState(blockPos.below()).getValue((Property)BlockStateProperties.SLAB_TYPE)).equals((Object)SlabType.BOTTOM)) {
                    int currentLayers;
                    int n = currentLayers = world.getBlockState(blockPos).getBlock() instanceof SnowLayerBlock ? (Integer)world.getBlockState(blockPos).getValue((Property)SnowLayerBlock.LAYERS) : 0;
                    if (currentLayers < 8) {
                        world.setBlockAndUpdate(blockPos, (BlockState)ModBlocksRegistry.SNOW_ON_TOP.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(currentLayers + 1)));
                        world.playSound(player, blockPos, SoundEvents.SNOW_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!player.isCreative()) {
                            item.shrink(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            } else if (VEGETATION_ON_TOP_ITEMS.containsKey(item.getItem())) {
                BlockPos blockPos = hitResult.getBlockPos().relative(hitResult.getDirection());
                if (world.getBlockState(blockPos).isAir() && world.getBlockState(blockPos.below()).getBlock() instanceof SlabBlock && ((SlabType)world.getBlockState(blockPos.below()).getValue((Property)BlockStateProperties.SLAB_TYPE)).equals((Object)SlabType.BOTTOM) && !item.is(Items.SEAGRASS)) {
                    world.setBlock(blockPos, VEGETATION_ON_TOP_ITEMS.get(item.getItem()).defaultBlockState(), 0);
                    world.playSound(player, blockPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        item.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (world.getBlockState(blockPos).is(Blocks.WATER) && world.getBlockState(blockPos.below()).getBlock() instanceof SlabBlock && ((SlabType)world.getBlockState(blockPos.below()).getValue((Property)BlockStateProperties.SLAB_TYPE)).equals((Object)SlabType.BOTTOM) && item.getItem().equals(Items.SEAGRASS)) {
                    world.setBlock(blockPos, ModBlocksRegistry.SEAGRASS_ON_TOP.defaultBlockState(), 0);
                    world.playSound(player, blockPos, SoundEvents.WET_GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        item.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        });
    }

    private static void registerSlabPlacementCallback() {
        ServerChunkEvents.CHUNK_GENERATE.register((serverWorld, worldChunk) -> {
            List topAttachedSlabPositions;
            List botAttachedSlabPositions = (List)worldChunk.getAttached(SlabChunkAttachment.BOT_SLAB_POSITIONS);
            if (botAttachedSlabPositions != null && !botAttachedSlabPositions.isEmpty()) {
                for (BlockPos pos : botAttachedSlabPositions) {
                    RegisterCallbacks.placeBottomSlab(worldChunk, pos);
                }
                worldChunk.setAttached(SlabChunkAttachment.BOT_SLAB_POSITIONS, new ArrayList());
            }
            if ((topAttachedSlabPositions = (List)worldChunk.getAttached(SlabChunkAttachment.TOP_SLAB_POSITIONS)) != null && !topAttachedSlabPositions.isEmpty()) {
                for (BlockPos pos : topAttachedSlabPositions) {
                    RegisterCallbacks.placeTopSlab(worldChunk, pos);
                }
                worldChunk.setAttached(SlabChunkAttachment.TOP_SLAB_POSITIONS, new ArrayList());
            }
        });
    }

    private static void placeBottomSlab(LevelChunk worldChunk, BlockPos placePos) {
        BlockPos blockBelowPos = placePos.below();
        BlockPos blockAbovePos = placePos.above();
        BlockState blockAboveState = worldChunk.getBlockState(blockAbovePos);
        BlockState currentBlockState = worldChunk.getBlockState(placePos);
        BlockState blockBelowState = worldChunk.getBlockState(blockBelowPos);
        if (!(currentBlockState.is(Blocks.AIR) || currentBlockState.is(Blocks.WATER) || currentBlockState.is(Blocks.CAVE_AIR) || currentBlockState.is(Blocks.VOID_AIR) || currentBlockState.is(Blocks.LAVA) || ModSlabsMap.ON_TOP_VEGETATION_BLOCKS_MAP.containsKey(currentBlockState.getBlock()) || currentBlockState.is(Blocks.SNOW))) {
            return;
        }
        BlockState slabState = ModSlabsMap.getSlabForBlock(blockBelowState.getBlock()).defaultBlockState();
        if (slabState.getBlock().equals(Blocks.AIR)) {
            return;
        }
        int blockBelowY = blockBelowPos.getY();
        int blockAboveY = blockAbovePos.getY();
        int placeY = placePos.getY();
        int sectionIndex = worldChunk.getSectionIndex(blockAboveY);
        if (sectionIndex < 0 || sectionIndex >= worldChunk.getSections().length) {
            return;
        }
        LevelChunkSection placePosSection = worldChunk.getSection(worldChunk.getSectionIndex(placeY));
        LevelChunkSection belowPosSection = worldChunk.getSection(worldChunk.getSectionIndex(blockBelowY));
        LevelChunkSection abovePosSection = worldChunk.getSection(sectionIndex);
        if (SlabFeatureLogic.SOIL_SLAB_BLOCKS.contains(slabState.getBlock())) {
            belowPosSection.setBlockState(blockBelowPos.getX() & 0xF, blockBelowPos.getY() & 0xF, blockBelowPos.getZ() & 0xF, Blocks.DIRT.defaultBlockState());
        }
        if (slabState.is(ModBlocksRegistry.WARPED_NYLIUM_SLAB) || slabState.is(ModBlocksRegistry.CRIMSON_NYLIUM_SLAB)) {
            belowPosSection.setBlockState(blockBelowPos.getX() & 0xF, blockBelowPos.getY() & 0xF, blockBelowPos.getZ() & 0xF, Blocks.NETHERRACK.defaultBlockState());
        }
        slabState = RegisterCallbacks.updateBottomWaterloggedState(currentBlockState, blockAboveState, slabState);
        if (MyModConfig.enableVegetationOnSlabs) {
            RegisterCallbacks.placeVegetationOnTop(abovePosSection, currentBlockState, blockAboveState, blockAbovePos);
        }
        if (currentBlockState.is(Blocks.SNOW)) {
            if (MyModConfig.enableSnowOnSlabs) {
                abovePosSection.setBlockState(blockAbovePos.getX() & 0xF, blockAbovePos.getY() & 0xF, blockAbovePos.getZ() & 0xF, ModBlocksRegistry.SNOW_ON_TOP.defaultBlockState());
                if (SlabFeatureLogic.SOIL_SLAB_BLOCKS.contains(slabState.getBlock()) && !slabState.is(ModBlocksRegistry.PATH_SLAB)) {
                    slabState = (BlockState)slabState.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true));
                }
            } else {
                slabState = ModBlocksRegistry.SNOW_SLAB.defaultBlockState();
            }
        }
        placePosSection.setBlockState(placePos.getX() & 0xF, placePos.getY() & 0xF, placePos.getZ() & 0xF, (BlockState)slabState.setValue((Property)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true)));
    }

    private static void placeTopSlab(LevelChunk worldChunk, BlockPos placePos) {
        BlockState blockAboveState = worldChunk.getBlockState(placePos.above());
        BlockState slabState = ModSlabsMap.getSlabForBlock(blockAboveState.getBlock()).defaultBlockState();
        if (slabState.getBlock().equals(Blocks.AIR)) {
            return;
        }
        if (SlabFeatureLogic.SOIL_SLAB_BLOCKS.contains(slabState.getBlock())) {
            slabState = ModBlocksRegistry.DIRT_SLAB.defaultBlockState();
        }
        if (slabState.is(ModBlocksRegistry.WARPED_NYLIUM_SLAB) || slabState.is(ModBlocksRegistry.CRIMSON_NYLIUM_SLAB)) {
            slabState = ModBlocksRegistry.NETHERRACK_SLAB.defaultBlockState();
        }
        slabState = RegisterCallbacks.updateTopWaterloggedState(worldChunk, placePos, slabState);
        LevelChunkSection section = worldChunk.getSection(worldChunk.getSectionIndex(placePos.getY()));
        section.setBlockState(placePos.getX() & 0xF, placePos.getY() & 0xF, placePos.getZ() & 0xF, (BlockState)((BlockState)slabState.setValue((Property)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP));
    }

    private static void placeVegetationOnTop(LevelChunkSection abovePosSection, BlockState currentBlockState, BlockState blockAboveState, BlockPos blockAbovePos) {
        if (!(!ModSlabsMap.ON_TOP_VEGETATION_BLOCKS_MAP.containsKey(currentBlockState.getBlock()) || currentBlockState.is(Blocks.SEAGRASS) && blockAboveState.is(Blocks.AIR))) {
            abovePosSection.setBlockState(blockAbovePos.getX() & 0xF, blockAbovePos.getY() & 0xF, blockAbovePos.getZ() & 0xF, ModSlabsMap.ON_TOP_VEGETATION_BLOCKS_MAP.get(currentBlockState.getBlock()).defaultBlockState());
        }
    }

    private static BlockState updateBottomWaterloggedState(BlockState currentBlockState, BlockState blockAboveState, BlockState slabState) {
        if (slabState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (currentBlockState.is(Blocks.WATER) || blockAboveState.is(Blocks.WATER) || currentBlockState.is(Blocks.SEAGRASS))) {
            return (BlockState)slabState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return slabState;
    }

    private static BlockState updateTopWaterloggedState(LevelChunk worldChunk, BlockPos currentPos, BlockState slabState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!worldChunk.getBlockState(currentPos.relative(direction)).is(Blocks.WATER)) continue;
            return (BlockState)slabState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return slabState;
    }

    static {
        VEGETATION_ON_TOP_ITEMS.put(Items.POPPY, ModBlocksRegistry.POPPY_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.DANDELION, ModBlocksRegistry.DANDELION_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.AZURE_BLUET, ModBlocksRegistry.AZURE_BLUET_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.CORNFLOWER, ModBlocksRegistry.CORNFLOWER_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.SHORT_GRASS, ModBlocksRegistry.SHORT_GRASS_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.FERN, ModBlocksRegistry.FERN_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.DEAD_BUSH, ModBlocksRegistry.DEAD_BUSH_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.BROWN_MUSHROOM, ModBlocksRegistry.BROWN_MUSHROOM_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.RED_MUSHROOM, ModBlocksRegistry.RED_MUSHROOM_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(Items.SEAGRASS, ModBlocksRegistry.SEAGRASS_ON_TOP);
    }
}

