/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.block.customslabs.specialslabs.dimensions;

import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.lighting.LightEngine;

public class NyliumSlab
extends CustomSlab
implements BonemealableBlock {
    public NyliumSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED, GENERATED});
    }

    private static boolean stayAlive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = world.getBlockState(blockPos);
        int i = LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)Blocks.WARPED_NYLIUM.defaultBlockState(), (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.getLightBlock((BlockGetter)world, blockPos));
        return i < 15;
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!NyliumSlab.stayAlive(state, (LevelReader)world, pos)) {
            if (state.getValue((Property)TYPE) == SlabType.TOP) {
                world.setBlock(pos, (BlockState)ModBlocksRegistry.NETHERRACK_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.TOP), 3);
            } else if (state.getValue((Property)TYPE) == SlabType.DOUBLE) {
                world.setBlock(pos, (BlockState)ModBlocksRegistry.NETHERRACK_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.DOUBLE), 3);
            } else if (state.getValue((Property)TYPE) == SlabType.BOTTOM) {
                world.setBlock(pos, (BlockState)ModBlocksRegistry.NETHERRACK_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM), 3);
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

