/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.block.customslabs.specialslabs.dimensions;

import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class NetherrackSlab
extends CustomSlab
implements BonemealableBlock {
    public NetherrackSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED, GENERATED});
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        if (!world.getBlockState(pos.above()).propagatesSkylightDown((BlockGetter)world, pos)) {
            return false;
        }
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            if (!world.getBlockState(blockPos).is(BlockTags.NYLIUM)) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        boolean hasWarped = false;
        boolean hasCrimson = false;
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState blockState = world.getBlockState(blockPos);
            if (blockState.is(Blocks.WARPED_NYLIUM) || blockState.is(ModBlocksRegistry.WARPED_NYLIUM_SLAB)) {
                hasWarped = true;
            }
            if (blockState.is(Blocks.CRIMSON_NYLIUM) || blockState.is(ModBlocksRegistry.CRIMSON_NYLIUM_SLAB)) {
                hasCrimson = true;
            }
            if (!hasWarped || !hasCrimson) continue;
            break;
        }
        BlockState newState = null;
        if (hasWarped && hasCrimson) {
            newState = random.nextBoolean() ? ModBlocksRegistry.WARPED_NYLIUM_SLAB.defaultBlockState() : ModBlocksRegistry.CRIMSON_NYLIUM_SLAB.defaultBlockState();
        } else if (hasWarped) {
            newState = ModBlocksRegistry.WARPED_NYLIUM_SLAB.defaultBlockState();
        } else if (hasCrimson) {
            newState = ModBlocksRegistry.CRIMSON_NYLIUM_SLAB.defaultBlockState();
        }
        if (newState != null) {
            SlabType slabType = (SlabType)state.getValue((Property)SlabBlock.TYPE);
            newState = (BlockState)newState.setValue((Property)SlabBlock.TYPE, (Comparable)slabType);
            world.setBlock(pos, newState, 3);
        }
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

