/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.block.customslabs.specialslabs;

import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MudSlab
extends CustomSlab {
    protected static final VoxelShape BOTTOM_SHAPE_COL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape FULL_SHAPE_COL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE_COL = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape BOTTOM_SHAPE_OUT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE_OUT = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public MudSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED, GENERATED});
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        switch (slabType) {
            case DOUBLE: {
                return FULL_SHAPE_COL;
            }
            case TOP: {
                return TOP_SHAPE_COL;
            }
        }
        return BOTTOM_SHAPE_COL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        switch (slabType) {
            case DOUBLE: {
                return Shapes.block();
            }
            case TOP: {
                return TOP_SHAPE_OUT;
            }
        }
        return BOTTOM_SHAPE_OUT;
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        switch (slabType) {
            case DOUBLE: {
                return Shapes.block();
            }
            case TOP: {
                return TOP_SHAPE_OUT;
            }
        }
        return BOTTOM_SHAPE_OUT;
    }

    protected float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        switch (slabType) {
            case DOUBLE: {
                return 0.2f;
            }
        }
        return 1.0f;
    }
}

