/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.block.customslabs.soilslabs;

import com.mojang.serialization.MapCodec;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class PodzolSlab
extends CustomSlab {
    public static final MapCodec<PodzolSlab> CODEC = PodzolSlab.simpleCodec(PodzolSlab::new);
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;

    public PodzolSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<PodzolSlab> codec() {
        return CODEC;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP) {
            state = (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(PodzolSlab.isSnow(neighborState)));
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        BlockState currentState = ctx.getLevel().getBlockState(blockPos);
        if (currentState.is((Block)this) && currentState.getValue((Property)TYPE) != SlabType.DOUBLE) {
            return (BlockState)((BlockState)currentState.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        BlockState blockAbove = ctx.getLevel().getBlockState(blockPos.above());
        BlockState defaultState = (BlockState)this.defaultBlockState().setValue((Property)SNOWY, (Comparable)Boolean.valueOf(PodzolSlab.isSnow(blockAbove)));
        FluidState fluidState = ctx.getLevel().getFluidState(blockPos);
        BlockState slabState = (BlockState)((BlockState)defaultState.setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        Direction direction = ctx.getClickedFace();
        if (!(direction == Direction.DOWN || direction != Direction.UP && ctx.getClickLocation().y - (double)blockPos.getY() > 0.5)) {
            return slabState;
        }
        return (BlockState)slabState.setValue((Property)TYPE, (Comparable)SlabType.TOP);
    }

    private static boolean isSnow(BlockState state) {
        return state.is(BlockTags.SNOW);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SNOWY, TYPE, WATERLOGGED, GENERATED});
    }
}

