/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.block.customslabs.soilslabs;

import com.mojang.serialization.MapCodec;
import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PathSlab
extends CustomSlab {
    public static final MapCodec<PathSlab> CODEC = PathSlab.simpleCodec(PathSlab::new);
    protected static final VoxelShape BOTTOM_SHAPE_COL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE_COL = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape DOUBLE_SHAPE_COL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public PathSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED, GENERATED});
    }

    public MapCodec<PathSlab> codec() {
        return CODEC;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        switch (slabType) {
            case DOUBLE: {
                return DOUBLE_SHAPE_COL;
            }
            case TOP: {
                return TOP_SHAPE_COL;
            }
        }
        return BOTTOM_SHAPE_COL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        switch (slabType) {
            case DOUBLE: {
                return DOUBLE_SHAPE_COL;
            }
            case TOP: {
                return TOP_SHAPE_COL;
            }
        }
        return BOTTOM_SHAPE_COL;
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        SlabType slabType = (SlabType)state.getValue((Property)TYPE);
        switch (slabType) {
            case DOUBLE: {
                world.setBlockAndUpdate(pos, (BlockState)ModBlocksRegistry.DIRT_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.DOUBLE));
                break;
            }
            case TOP: {
                world.setBlockAndUpdate(pos, (BlockState)ModBlocksRegistry.DIRT_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.TOP));
                break;
            }
            default: {
                world.setBlockAndUpdate(pos, (BlockState)ModBlocksRegistry.DIRT_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM));
            }
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.above());
        return !blockState.isSolid() || blockState.getBlock() instanceof FenceGateBlock;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        BlockState blockState = ctx.getLevel().getBlockState(blockPos);
        if (blockState.is((Block)this)) {
            return (BlockState)((BlockState)blockState.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidState = ctx.getLevel().getFluidState(blockPos);
        BlockState blockState2 = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        Direction direction = ctx.getClickedFace();
        if (!(direction == Direction.DOWN || direction != Direction.UP && ctx.getClickLocation().y - (double)blockPos.getY() > 0.5)) {
            return blockState2;
        }
        return !blockState2.canSurvive((LevelReader)ctx.getLevel(), blockPos) ? Block.pushEntitiesUp((BlockState)this.defaultBlockState(), (BlockState)Blocks.DIRT.defaultBlockState(), (LevelAccessor)ctx.getLevel(), (BlockPos)blockPos) : (BlockState)blockState2.setValue((Property)TYPE, (Comparable)SlabType.TOP);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP && !state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return state;
    }
}

