/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.block.customslabs.soilslabs;

import com.mojang.serialization.MapCodec;
import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class MyceliumSlab
extends CustomSlab {
    public static final MapCodec<MyceliumSlab> CODEC = MyceliumSlab.simpleCodec(MyceliumSlab::new);
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;

    public MyceliumSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<MyceliumSlab> codec() {
        return CODEC;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP) {
            state = (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(MyceliumSlab.isSnow(neighborState)));
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        BlockState currentState = ctx.getLevel().getBlockState(blockPos);
        if (currentState.is((Block)this) && currentState.getValue((Property)TYPE) != SlabType.DOUBLE) {
            return (BlockState)((BlockState)currentState.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        BlockState blockAbove = ctx.getLevel().getBlockState(blockPos.above());
        BlockState defaultState = (BlockState)this.defaultBlockState().setValue((Property)SNOWY, (Comparable)Boolean.valueOf(MyceliumSlab.isSnow(blockAbove)));
        FluidState fluidState = ctx.getLevel().getFluidState(blockPos);
        BlockState slabState = (BlockState)((BlockState)defaultState.setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        Direction direction = ctx.getClickedFace();
        if (!(direction == Direction.DOWN || direction != Direction.UP && ctx.getClickLocation().y - (double)blockPos.getY() > 0.5)) {
            return slabState;
        }
        return (BlockState)slabState.setValue((Property)TYPE, (Comparable)SlabType.TOP);
    }

    private static boolean isSnow(BlockState state) {
        return state.is(BlockTags.SNOW);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SNOWY, TYPE, WATERLOGGED, GENERATED});
    }

    private static boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(Blocks.SNOW) && (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) == 1 || blockState.is(ModBlocksRegistry.SNOW_SLAB)) {
            return true;
        }
        if (blockState.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)Blocks.GRASS_BLOCK.defaultBlockState(), (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.getLightBlock((BlockGetter)world, blockPos));
        return i < world.getMaxLightLevel();
    }

    private static boolean canSpread(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        return MyceliumSlab.canSurvive(state, world, pos) && !world.getFluidState(blockPos).is(FluidTags.WATER);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (random.nextInt(10) == 0) {
            world.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.55, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        block4: {
            block2: {
                block5: {
                    block3: {
                        if (MyceliumSlab.canSurvive(state, (LevelReader)world, pos)) break block2;
                        if (state.getValue((Property)TYPE) != SlabType.TOP) break block3;
                        world.setBlock(pos, (BlockState)ModBlocksRegistry.DIRT_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.TOP), 3);
                        break block4;
                    }
                    if (state.getValue((Property)TYPE) != SlabType.DOUBLE) break block5;
                    world.setBlock(pos, (BlockState)ModBlocksRegistry.DIRT_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.DOUBLE), 3);
                    break block4;
                }
                if (state.getValue((Property)TYPE) != SlabType.BOTTOM) break block4;
                world.setBlock(pos, (BlockState)ModBlocksRegistry.DIRT_SLAB.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM), 3);
                break block4;
            }
            if (world.getMaxLocalRawBrightness(pos.above()) >= 9) {
                BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)((SlabType)world.getBlockState(pos).getValue((Property)TYPE)));
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (!world.getBlockState(blockPos).is(ModBlocksRegistry.DIRT_SLAB) || !MyceliumSlab.canSpread(blockState, (LevelReader)world, blockPos)) continue;
                    world.setBlockAndUpdate(blockPos, (BlockState)((BlockState)blockState.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(world.getBlockState(blockPos.above()).is(Blocks.SNOW)))).setValue((Property)TYPE, (Comparable)((SlabType)world.getBlockState(blockPos).getValue((Property)TYPE))));
                }
            }
        }
    }
}

