/*
 * Decompiled with CFR 0.152.
 */
package net.countered.counteredsaccuratehitboxes;

import com.mojang.blaze3d.platform.InputConstants;
import net.countered.counteredsaccuratehitboxes.util.HitboxAttachment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounteredsAccurateHitboxes
implements ModInitializer {
    public static final String MOD_ID = "countereds-accurate-hitboxes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"countereds-accurate-hitboxes");

    public void onInitialize() {
        LOGGER.info("Initializing Countered's Accurate Hitboxes");
        HitboxAttachment.register();
    }

    private void spawnMobsDebug() {
        KeyMapping keyBinding = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.mymod.spawn_all_entities", InputConstants.Type.KEYSYM, 298, "category.mymod.debug"));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            while (keyBinding.consumeClick()) {
                int spacing = 4;
                int gridWidth = 10;
                int count = 0;
                for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
                    if (type == EntityType.PLAYER) continue;
                    for (int i = 0; i < 1; ++i) {
                        BlockPos spawnPos;
                        Entity entity = type.create((Level)server.overworld());
                        if (!(entity instanceof Mob)) continue;
                        Mob living = (Mob)entity;
                        int x = count % gridWidth * spacing;
                        int z = count / gridWidth * spacing;
                        BlockPos blockPos = spawnPos = i == 0 ? server.overworld().getSharedSpawnPos().offset(x, 50, z) : server.overworld().getSharedSpawnPos().offset(x, 55, z);
                        if (i == 1) {
                            living.setBaby(true);
                        }
                        living.moveTo(spawnPos, 0.0f, 0.0f);
                        living.setNoAi(true);
                        living.setNoGravity(true);
                        living.setInvulnerable(true);
                        server.overworld().addFreshEntity((Entity)living);
                        ++count;
                    }
                }
            }
        });
    }
}

