/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceDishModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class SecureRedstoneInterfaceRenderer
implements BlockEntityRenderer<SecureRedstoneInterfaceBlockEntity> {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/block/secure_redstone_interface_dish.png");
    private final SecureRedstoneInterfaceDishModel model;

    public SecureRedstoneInterfaceRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SecureRedstoneInterfaceDishModel(ctx.bakeLayer(ClientHandler.SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION));
    }

    public void render(SecureRedstoneInterfaceBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay);
        if (!be.isModuleEnabled(ModuleType.DISGUISE) && !((Boolean)be.getBlockState().getValue((Property)SecureRedstoneInterfaceBlock.SENDER)).booleanValue()) {
            pose.translate(0.5, 0.5, 0.5);
            pose.mulPose(((Direction)be.getBlockState().getValue((Property)SecureRedstoneInterfaceBlock.FACING)).getRotation());
            pose.translate(0.0, -0.49999, 0.0);
            this.model.rotate(Mth.lerp((float)partialTicks, (float)be.getOriginalDishRotationDegrees(), (float)be.getDishRotationDegrees()));
            this.model.renderToBuffer(pose, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, -1);
        }
    }
}

