/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.components.PasscodeData;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CheckBriefcasePasscode(String passcode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CheckBriefcasePasscode> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("check_briefcase_passcode"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CheckBriefcasePasscode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, packet -> PasscodeUtils.hashPasscodeWithoutSalt(packet.passcode), CheckBriefcasePasscode::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        Player player = ctx.player();
        ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.BRIEFCASE.get());
        PasscodeData passcodeData = (PasscodeData)briefcase.get(SCContent.PASSCODE_DATA);
        if (passcodeData != null) {
            if (PasscodeUtils.isOnCooldown(player)) {
                PlayerUtils.sendMessageToPlayer(player, Component.literal((String)"SecurityCraft"), Component.translatable((String)"messages.securitycraft:passcodeProtected.onCooldown"), ChatFormatting.RED);
                if (((Boolean)ConfigHandler.SERVER.passcodeSpamLogWarningEnabled.get()).booleanValue()) {
                    SecurityCraft.LOGGER.warn(String.format((String)ConfigHandler.SERVER.passcodeSpamLogWarning.get(), player.getGameProfile().getName(), ((BriefcaseItem)((Object)SCContent.BRIEFCASE.get())).getDescription().getString(), new GlobalPos(player.level().dimension(), player.blockPosition())));
                }
                return;
            }
            String dataCode = passcodeData.passcode();
            if (dataCode.length() == 4) {
                PasscodeData.hashAndSetPasscode(briefcase, PasscodeUtils.hashPasscodeWithoutSalt(dataCode), newPasscodeData -> BriefcaseItem.checkPasscode(player, briefcase, this.passcode, newPasscodeData));
            } else {
                BriefcaseItem.checkPasscode(player, briefcase, this.passcode, passcodeData);
            }
        }
    }
}

