/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PlayAlarmSound
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PlayAlarmSound> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("play_alarm_sound"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayAlarmSound> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PlayAlarmSound>(){

        public PlayAlarmSound decode(RegistryFriendlyByteBuf buf) {
            PlayAlarmSound packet = new PlayAlarmSound();
            packet.bePos = buf.readBlockPos();
            packet.sound = (Holder)SoundEvent.STREAM_CODEC.decode((Object)buf);
            packet.soundX = buf.readInt();
            packet.soundY = buf.readInt();
            packet.soundZ = buf.readInt();
            packet.volume = buf.readFloat();
            packet.pitch = buf.readFloat();
            packet.seed = buf.readLong();
            return packet;
        }

        public void encode(RegistryFriendlyByteBuf buf, PlayAlarmSound packet) {
            buf.writeBlockPos(packet.bePos);
            SoundEvent.STREAM_CODEC.encode((Object)buf, packet.sound);
            buf.writeInt(packet.soundX);
            buf.writeInt(packet.soundY);
            buf.writeInt(packet.soundZ);
            buf.writeFloat(packet.volume);
            buf.writeFloat(packet.pitch);
            buf.writeLong(packet.seed);
        }
    };
    private BlockPos bePos;
    private Holder<SoundEvent> sound;
    private int soundX;
    private int soundY;
    private int soundZ;
    private float volume;
    private float pitch;
    private long seed;

    public PlayAlarmSound() {
    }

    public PlayAlarmSound(BlockPos bePos, Holder<SoundEvent> sound, float volume, float pitch, long seed) {
        this.bePos = bePos;
        this.sound = sound;
        this.soundX = (int)((float)bePos.getX() * 8.0f);
        this.soundY = (int)((float)bePos.getY() * 8.0f);
        this.soundZ = (int)((float)bePos.getZ() * 8.0f);
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public double getX() {
        return (float)this.soundX / 8.0f;
    }

    public double getY() {
        return (float)this.soundY / 8.0f;
    }

    public double getZ() {
        return (float)this.soundZ / 8.0f;
    }

    public void handle(IPayloadContext ctx) {
        Level level = ctx.player().level();
        BlockEntity blockEntity = level.getBlockEntity(this.bePos);
        if (blockEntity instanceof AlarmBlockEntity) {
            AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
            be.playSound(level, this.getX(), this.getY(), this.getZ(), this.sound, this.volume, this.pitch, this.seed);
        }
    }
}

