/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.geforcemods.securitycraft.SecurityCraftClient;
import net.geforcemods.securitycraft.compat.ium.IumCompat;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class}, priority=1100)
public class LevelRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private SectionRenderDispatcher sectionRenderDispatcher;
    @Shadow
    private ClientLevel level;

    @WrapWithCondition(method={"setupRender"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ViewArea;repositionCamera(DD)V")})
    private boolean securitycraft$shouldRepositionCamera(ViewArea viewArea, double x, double z) {
        return !PlayerUtils.isPlayerMountedOnCamera((LivingEntity)this.minecraft.player);
    }

    @Inject(method={"setupRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onSetupRender(Camera camera, Frustum frustum, boolean hasCapturedFrustum, boolean isSpectator, CallbackInfo ci) {
        if (FrameFeedHandler.isCapturingCamera() && SecurityCraftClient.INSTALLED_IUM_MOD == IumCompat.NONE) {
            ci.cancel();
        }
    }

    @Inject(method={"allChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SectionOcclusionGraph;waitAndReset(Lnet/minecraft/client/renderer/ViewArea;)V")})
    private void securitycraft$onAllChanged(CallbackInfo ci) {
        CameraViewAreaExtension.allChanged(this.sectionRenderDispatcher, (Level)this.level);
    }

    @Inject(method={"isSectionCompiled"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onIsSectionCompiled(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        SectionPos sectionPos;
        SectionRenderDispatcher.RenderSection renderSection;
        if (FrameFeedHandler.isCapturingCamera() && (renderSection = CameraViewAreaExtension.rawFetch((sectionPos = SectionPos.of((BlockPos)pos)).x(), sectionPos.y(), sectionPos.z(), false)) != null && renderSection.compiled.get() != SectionRenderDispatcher.CompiledSection.UNCOMPILED) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"), ordinal=1)
    private float securitycraft$modifyFogRenderDistance(float original) {
        if (FrameFeedHandler.isCapturingCamera()) {
            return FrameFeedHandler.getFrameFeedViewDistance(null) * 16;
        }
        return original;
    }
}

