/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class BlockEntityTracker<BE extends BlockEntity> {
    public static final BlockEntityTracker<SonicSecuritySystemBlockEntity> SONIC_SECURITY_SYSTEM = new BlockEntityTracker<SonicSecuritySystemBlockEntity>(be -> 30);
    public static final BlockEntityTracker<BlockChangeDetectorBlockEntity> BLOCK_CHANGE_DETECTOR = new BlockEntityTracker<BlockChangeDetectorBlockEntity>(be -> be.getRange());
    public static final BlockEntityTracker<RiftStabilizerBlockEntity> RIFT_STABILIZER = new BlockEntityTracker<RiftStabilizerBlockEntity>(RiftStabilizerBlockEntity::getRange);
    public static final BlockEntityTracker<SecureRedstoneInterfaceBlockEntity> SECURE_REDSTONE_INTERFACE = new BlockEntityTracker<SecureRedstoneInterfaceBlockEntity>(SecureRedstoneInterfaceBlockEntity::getSenderRange);
    public static final BlockEntityTracker<SecurityCameraBlockEntity> FRAME_VIEWED_SECURITY_CAMERAS = new BlockEntityTracker<SecurityCameraBlockEntity>(be -> 0);
    private final Map<ResourceKey<Level>, Collection<BlockPos>> trackedBlockEntities = new ConcurrentHashMap<ResourceKey<Level>, Collection<BlockPos>>();
    private final Function<BE, Integer> range;

    private BlockEntityTracker(Function<BE, Integer> range) {
        this.range = range;
    }

    public void track(BE be) {
        this.getTrackedBlockEntities(be.getLevel()).add(be.getBlockPos().immutable());
    }

    public void stopTracking(BE be) {
        this.getTrackedBlockEntities(be.getLevel()).remove(be.getBlockPos());
    }

    public void clear() {
        this.trackedBlockEntities.clear();
    }

    public List<BE> getBlockEntitiesInRange(Level level, BlockPos pos) {
        return this.getBlockEntitiesInRange(level, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
    }

    public List<BE> getBlockEntitiesInRange(Level level, Vec3 pos) {
        return this.getBlockEntitiesWithCondition(level, be -> this.canReach(be, pos));
    }

    public List<BE> getBlockEntitiesAround(Level level, BlockPos pos, int range) {
        return this.iterate(level, (list, bePos) -> {
            if (this.isInRange(pos, range, new Vec3((double)bePos.getX(), (double)bePos.getY(), (double)bePos.getZ()))) {
                list.add(level.getBlockEntity(bePos));
            }
        });
    }

    public List<BE> getBlockEntitiesWithCondition(Level level, Predicate<BE> condition) {
        return this.iterate(level, (list, bePos) -> {
            BlockEntity be = level.getBlockEntity(bePos);
            if (be != null && condition.test(be)) {
                list.add(be);
            }
        });
    }

    private List<BE> iterate(Level level, BiConsumer<List<BE>, BlockPos> listAdder) {
        Collection<BlockPos> blockEntities = this.getTrackedBlockEntities(level);
        ArrayList returnValue = new ArrayList();
        Iterator<BlockPos> it = blockEntities.iterator();
        while (it.hasNext()) {
            BlockPos bePos = it.next();
            if (bePos != null) {
                try {
                    listAdder.accept(returnValue, bePos);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            it.remove();
        }
        return returnValue;
    }

    public Collection<BlockPos> getTrackedBlockEntities(Level level) {
        Collection<BlockPos> blockEntities = this.trackedBlockEntities.get(level.dimension());
        if (blockEntities == null) {
            blockEntities = ConcurrentHashMap.newKeySet();
            this.trackedBlockEntities.put((ResourceKey<Level>)level.dimension(), blockEntities);
        }
        return blockEntities;
    }

    public boolean canReach(BE be, Vec3 pos) {
        return this.isInRange(be.getBlockPos(), this.range.apply(be), pos);
    }

    public boolean isInRange(BlockPos around, int range, Vec3 pos) {
        AABB testRange = new AABB(around).inflate((double)range);
        return testRange.minX <= pos.x && testRange.minY <= pos.y && testRange.minZ <= pos.z && testRange.maxX >= pos.x && testRange.maxY >= pos.y && testRange.maxZ >= pos.z;
    }
}

