/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.components.GlobalPositions;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SonicSecuritySystemItem
extends BlockItem {
    public static final GlobalPositions DEFAULT_POSITIONS = GlobalPositions.sized(30);

    public SonicSecuritySystemItem(Item.Properties properties) {
        super((Block)SCContent.SONIC_SECURITY_SYSTEM.get(), properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        GlobalPositions sssLinkedBlocks;
        BlockPos pos;
        BlockEntity be;
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (!player.isShiftKeyDown() && (be = level.getBlockEntity(pos = ctx.getClickedPos())) instanceof ILockable) {
            IOwnable ownable;
            if (be instanceof IOwnable && !(ownable = (IOwnable)be).isOwnedBy((Entity)player)) {
                if (!(be.getBlockState().getBlock() instanceof IDisguisable) || !IDisguisable.getDisguisedBlockState(be).isPresent()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", ownable.getOwner().getName()), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
            } else {
                GlobalPositions positions = (GlobalPositions)stack.get(SCContent.SSS_LINKED_BLOCKS);
                if (positions != null) {
                    GlobalPos globalPos = new GlobalPos(level.dimension(), pos);
                    if (positions.remove(SCContent.SSS_LINKED_BLOCKS, stack, globalPos)) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.blockUnlinked", Utils.localize(level.getBlockState(pos).getBlock().getDescriptionId(), new Object[0]), pos), ChatFormatting.GREEN);
                    } else if (positions.add((Supplier<DataComponentType<GlobalPositions>>)SCContent.SSS_LINKED_BLOCKS, stack, globalPos)) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.blockLinked", Utils.localize(level.getBlockState(pos).getBlock().getDescriptionId(), new Object[0]), pos), ChatFormatting.GREEN);
                    } else {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.linkMaxReached", 30), ChatFormatting.DARK_RED);
                        return InteractionResult.FAIL;
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if ((sssLinkedBlocks = (GlobalPositions)stack.get(SCContent.SSS_LINKED_BLOCKS)) != null && sssLinkedBlocks.isEmpty()) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.notLinked", new Object[0]), ChatFormatting.DARK_RED);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            ClientHandler.displaySSSItemScreen(player.getItemInHand(hand));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        long numOfLinkedBlocks;
        GlobalPositions sssLinkedBlocks = (GlobalPositions)stack.get(SCContent.SSS_LINKED_BLOCKS);
        if (sssLinkedBlocks != null && (numOfLinkedBlocks = sssLinkedBlocks.positions().stream().filter(Objects::nonNull).count()) > 0L) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:sonicSecuritySystem.linkedTo", numOfLinkedBlocks).withStyle(Utils.GRAY_STYLE));
        }
    }
}

