/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BriefcaseMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SIZE = 12;
    private final ItemContainer briefcaseInventory;

    public BriefcaseMenu(int windowId, Inventory playerInventory, ItemContainer briefcaseInventory) {
        super((MenuType)SCContent.BRIEFCASE_INVENTORY_MENU.get(), windowId);
        int j;
        int i;
        this.briefcaseInventory = briefcaseInventory;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot(new Slot(this, briefcaseInventory, j + i * 4, 53 + j * 18, 17 + i * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return stack.getItem() != SCContent.BRIEFCASE.get();
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (index < 12) {
                if (!this.moveItemStackTo(slotStack, 12, 48, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, slotStackCopy);
            } else if (!this.moveItemStackTo(slotStack, 0, 12, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return slotStackCopy;
    }

    public void clicked(int slot, int dragType, ClickType clickType, Player player) {
        if (slot < 0 || this.getSlot(slot) == null || !(this.getSlot(slot).getItem().getItem() instanceof BriefcaseItem)) {
            super.clicked(slot, dragType, clickType, player);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        this.briefcaseInventory.stopOpen(player);
    }
}

