/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IMSBomb
extends Fireball {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.defineId(IMSBomb.class, Owner.getSerializer());
    private static final EntityDataAccessor<Integer> LAUNCH_TIME = SynchedEntityData.defineId(IMSBomb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int ticksFlying = 0;
    private boolean launching = true;
    private boolean isFast;
    private Vec3 upwardsSpeed;

    public IMSBomb(EntityType<IMSBomb> type, Level level) {
        super((EntityType)SCContent.IMS_BOMB_ENTITY.get(), level);
    }

    public IMSBomb(Level level, double x, double y, double z, Vec3 acceleration, int height, IMSBlockEntity be) {
        super((EntityType)SCContent.IMS_BOMB_ENTITY.get(), x, y, z, acceleration, level);
        Owner owner = be.getOwner();
        this.entityData.set(OWNER, (Object)new Owner(owner.getName(), owner.getUUID()));
        this.entityData.set(LAUNCH_TIME, (Object)(height * 3));
        this.isFast = be.isModuleEnabled(ModuleType.SPEED);
    }

    public void tick() {
        if (!this.launching) {
            super.tick();
        } else if (this.ticksFlying < this.getLaunchTime()) {
            if (this.upwardsSpeed == null) {
                this.upwardsSpeed = new Vec3(0.0, this.isFast ? (double)0.66f : (double)0.33f, 0.0);
            }
            this.ticksFlying += this.isFast ? 2 : 1;
            this.move(MoverType.SELF, this.upwardsSpeed);
        } else {
            this.launching = false;
        }
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide && result.getType() == HitResult.Type.BLOCK && this.level().getBlockState(((BlockHitResult)result).getBlockPos()).getBlock() != SCContent.IMS.get()) {
            BlockPos impactPos = ((BlockHitResult)result).getBlockPos();
            this.level().explode((Entity)this, (double)impactPos.getX(), (double)impactPos.getY() + 1.0, (double)impactPos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.5f : 7.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
            this.discard();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("ticksFlying", this.ticksFlying);
        tag.putBoolean("launching", this.launching);
        tag.putBoolean("isFast", this.isFast);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.ticksFlying = tag.getInt("ticksFlying");
        this.launching = tag.getBoolean("launching");
        this.isFast = tag.getBoolean("isFast");
    }

    public Owner getSCOwner() {
        return (Owner)this.entityData.get(OWNER);
    }

    public int getLaunchTime() {
        return (Integer)this.entityData.get(LAUNCH_TIME);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER, (Object)new Owner());
        builder.define(LAUNCH_TIME, (Object)0);
    }

    protected float getInertia() {
        return this.isFast ? 1.5f : 1.0f;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return false;
    }

    public float getPickRadius() {
        return 0.3f;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }
}

